/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String namespace;
    private List<MetricDatum> metricData = new ArrayList<MetricDatum>();

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public PutMetricDataRequest withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<MetricDatum> getMetricData() {
        return this.metricData;
    }

    public void setMetricData(Collection<MetricDatum> metricData) {
        if (metricData == null) {
            this.metricData = null;
            return;
        }
        this.metricData = new ArrayList<MetricDatum>(metricData);
    }

    public PutMetricDataRequest withMetricData(MetricDatum ... metricData) {
        if (this.getMetricData() == null) {
            this.metricData = new ArrayList<MetricDatum>(metricData.length);
        }
        for (MetricDatum value : metricData) {
            this.metricData.add(value);
        }
        return this;
    }

    public PutMetricDataRequest withMetricData(Collection<MetricDatum> metricData) {
        this.setMetricData(metricData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getMetricData() != null) {
            sb.append("MetricData: " + this.getMetricData());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricData() == null ? 0 : this.getMetricData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricData() == null ^ this.getMetricData() == null) {
            return false;
        }
        return other.getMetricData() == null || other.getMetricData().equals(this.getMetricData());
    }
}

