/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import java.util.HashMap;
import java.util.Map;

public enum StateValue {
    OK("OK"),
    ALARM("ALARM"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA");

    private String value;
    private static final Map<String, StateValue> enumMap;

    private StateValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static StateValue fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        if (enumMap.containsKey(value)) {
            return enumMap.get(value);
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    static {
        enumMap = new HashMap<String, StateValue>();
        enumMap.put("OK", OK);
        enumMap.put("ALARM", ALARM);
        enumMap.put("INSUFFICIENT_DATA", INSUFFICIENT_DATA);
    }
}

