/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.util.StringUtils;
import java.util.Date;

class DatapointStaxMarshaller {
    private static DatapointStaxMarshaller instance;

    DatapointStaxMarshaller() {
    }

    public void marshall(Datapoint _datapoint, Request<?> request, String _prefix) {
        String prefix;
        if (_datapoint.getTimestamp() != null) {
            prefix = _prefix + "Timestamp";
            Date timestamp = _datapoint.getTimestamp();
            request.addParameter(prefix, StringUtils.fromDate((Date)timestamp));
        }
        if (_datapoint.getSampleCount() != null) {
            prefix = _prefix + "SampleCount";
            Double sampleCount = _datapoint.getSampleCount();
            request.addParameter(prefix, StringUtils.fromDouble((Double)sampleCount));
        }
        if (_datapoint.getAverage() != null) {
            prefix = _prefix + "Average";
            Double average = _datapoint.getAverage();
            request.addParameter(prefix, StringUtils.fromDouble((Double)average));
        }
        if (_datapoint.getSum() != null) {
            prefix = _prefix + "Sum";
            Double sum = _datapoint.getSum();
            request.addParameter(prefix, StringUtils.fromDouble((Double)sum));
        }
        if (_datapoint.getMinimum() != null) {
            prefix = _prefix + "Minimum";
            Double minimum = _datapoint.getMinimum();
            request.addParameter(prefix, StringUtils.fromDouble((Double)minimum));
        }
        if (_datapoint.getMaximum() != null) {
            prefix = _prefix + "Maximum";
            Double maximum = _datapoint.getMaximum();
            request.addParameter(prefix, StringUtils.fromDouble((Double)maximum));
        }
        if (_datapoint.getUnit() != null) {
            prefix = _prefix + "Unit";
            String unit = _datapoint.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
    }

    public static DatapointStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new DatapointStaxMarshaller();
        }
        return instance;
    }
}

