/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteAlarmsRequestMarshaller
implements Marshaller<Request<DeleteAlarmsRequest>, DeleteAlarmsRequest> {
    public Request<DeleteAlarmsRequest> marshall(DeleteAlarmsRequest deleteAlarmsRequest) {
        if (deleteAlarmsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteAlarmsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAlarmsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DeleteAlarms");
        request.addParameter("Version", "2010-08-01");
        if (deleteAlarmsRequest.getAlarmNames() != null) {
            String prefix = "AlarmNames";
            List<String> alarmNames = deleteAlarmsRequest.getAlarmNames();
            int alarmNamesIndex = 1;
            String alarmNamesPrefix = prefix;
            for (String alarmNamesItem : alarmNames) {
                prefix = alarmNamesPrefix + ".member." + alarmNamesIndex;
                if (alarmNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)alarmNamesItem));
                }
                ++alarmNamesIndex;
            }
            String string = alarmNamesPrefix;
        }
        return request;
    }
}

