/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        String prefix;
        if (describeAlarmHistoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeAlarmHistoryRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmHistoryRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        if (describeAlarmHistoryRequest.getAlarmName() != null) {
            prefix = "AlarmName";
            String alarmName = describeAlarmHistoryRequest.getAlarmName();
            request.addParameter(prefix, StringUtils.fromString((String)alarmName));
        }
        if (describeAlarmHistoryRequest.getHistoryItemType() != null) {
            prefix = "HistoryItemType";
            String historyItemType = describeAlarmHistoryRequest.getHistoryItemType();
            request.addParameter(prefix, StringUtils.fromString((String)historyItemType));
        }
        if (describeAlarmHistoryRequest.getStartDate() != null) {
            prefix = "StartDate";
            Date startDate = describeAlarmHistoryRequest.getStartDate();
            request.addParameter(prefix, StringUtils.fromDate((Date)startDate));
        }
        if (describeAlarmHistoryRequest.getEndDate() != null) {
            prefix = "EndDate";
            Date endDate = describeAlarmHistoryRequest.getEndDate();
            request.addParameter(prefix, StringUtils.fromDate((Date)endDate));
        }
        if (describeAlarmHistoryRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeAlarmHistoryRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        if (describeAlarmHistoryRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeAlarmHistoryRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        return request;
    }
}

