/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.transform.DimensionStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAlarmsForMetricRequestMarshaller
implements Marshaller<Request<DescribeAlarmsForMetricRequest>, DescribeAlarmsForMetricRequest> {
    public Request<DescribeAlarmsForMetricRequest> marshall(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        String prefix;
        if (describeAlarmsForMetricRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeAlarmsForMetricRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsForMetricRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmsForMetric");
        request.addParameter("Version", "2010-08-01");
        if (describeAlarmsForMetricRequest.getMetricName() != null) {
            prefix = "MetricName";
            String metricName = describeAlarmsForMetricRequest.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (describeAlarmsForMetricRequest.getNamespace() != null) {
            prefix = "Namespace";
            String namespace = describeAlarmsForMetricRequest.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (describeAlarmsForMetricRequest.getStatistic() != null) {
            prefix = "Statistic";
            String statistic = describeAlarmsForMetricRequest.getStatistic();
            request.addParameter(prefix, StringUtils.fromString((String)statistic));
        }
        if (describeAlarmsForMetricRequest.getDimensions() != null) {
            prefix = "Dimensions";
            List<Dimension> dimensions = describeAlarmsForMetricRequest.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (Dimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionStaxMarshaller.getInstance().marshall(dimensionsItem, (Request<?>)request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (describeAlarmsForMetricRequest.getPeriod() != null) {
            prefix = "Period";
            Integer period = describeAlarmsForMetricRequest.getPeriod();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)period));
        }
        if (describeAlarmsForMetricRequest.getUnit() != null) {
            prefix = "Unit";
            String unit = describeAlarmsForMetricRequest.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
        return request;
    }
}

