/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        String prefix;
        if (describeAlarmsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeAlarmsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        if (describeAlarmsRequest.getAlarmNames() != null) {
            prefix = "AlarmNames";
            List<String> alarmNames = describeAlarmsRequest.getAlarmNames();
            int alarmNamesIndex = 1;
            String alarmNamesPrefix = prefix;
            for (String alarmNamesItem : alarmNames) {
                prefix = alarmNamesPrefix + ".member." + alarmNamesIndex;
                if (alarmNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)alarmNamesItem));
                }
                ++alarmNamesIndex;
            }
            prefix = alarmNamesPrefix;
        }
        if (describeAlarmsRequest.getAlarmNamePrefix() != null) {
            prefix = "AlarmNamePrefix";
            String alarmNamePrefix = describeAlarmsRequest.getAlarmNamePrefix();
            request.addParameter(prefix, StringUtils.fromString((String)alarmNamePrefix));
        }
        if (describeAlarmsRequest.getStateValue() != null) {
            prefix = "StateValue";
            String stateValue = describeAlarmsRequest.getStateValue();
            request.addParameter(prefix, StringUtils.fromString((String)stateValue));
        }
        if (describeAlarmsRequest.getActionPrefix() != null) {
            prefix = "ActionPrefix";
            String actionPrefix = describeAlarmsRequest.getActionPrefix();
            request.addParameter(prefix, StringUtils.fromString((String)actionPrefix));
        }
        if (describeAlarmsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeAlarmsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        if (describeAlarmsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeAlarmsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        return request;
    }
}

