/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class DimensionFilterStaxUnmarshaller
implements Unmarshaller<DimensionFilter, StaxUnmarshallerContext> {
    private static DimensionFilterStaxUnmarshaller instance;

    DimensionFilterStaxUnmarshaller() {
    }

    public DimensionFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        DimensionFilter dimensionFilter = new DimensionFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("Name", targetDepth)) {
                    dimensionFilter.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                dimensionFilter.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return dimensionFilter;
    }

    public static DimensionFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DimensionFilterStaxUnmarshaller();
        }
        return instance;
    }
}

