/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class DimensionStaxUnmarshaller
implements Unmarshaller<Dimension, StaxUnmarshallerContext> {
    private static DimensionStaxUnmarshaller instance;

    DimensionStaxUnmarshaller() {
    }

    public Dimension unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        Dimension dimension = new Dimension();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("Name", targetDepth)) {
                    dimension.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                dimension.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return dimension;
    }

    public static DimensionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DimensionStaxUnmarshaller();
        }
        return instance;
    }
}

