/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class EnableAlarmActionsRequestMarshaller
implements Marshaller<Request<EnableAlarmActionsRequest>, EnableAlarmActionsRequest> {
    public Request<EnableAlarmActionsRequest> marshall(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        if (enableAlarmActionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(EnableAlarmActionsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableAlarmActionsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "EnableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        if (enableAlarmActionsRequest.getAlarmNames() != null) {
            String prefix = "AlarmNames";
            List<String> alarmNames = enableAlarmActionsRequest.getAlarmNames();
            int alarmNamesIndex = 1;
            String alarmNamesPrefix = prefix;
            for (String alarmNamesItem : alarmNames) {
                prefix = alarmNamesPrefix + ".member." + alarmNamesIndex;
                if (alarmNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)alarmNamesItem));
                }
                ++alarmNamesIndex;
            }
            String string = alarmNamesPrefix;
        }
        return request;
    }
}

