/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.transform.DimensionStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        String prefix;
        if (getMetricStatisticsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetMetricStatisticsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMetricStatisticsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        if (getMetricStatisticsRequest.getNamespace() != null) {
            prefix = "Namespace";
            String namespace = getMetricStatisticsRequest.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (getMetricStatisticsRequest.getMetricName() != null) {
            prefix = "MetricName";
            String metricName = getMetricStatisticsRequest.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (getMetricStatisticsRequest.getDimensions() != null) {
            prefix = "Dimensions";
            List<Dimension> dimensions = getMetricStatisticsRequest.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (Dimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionStaxMarshaller.getInstance().marshall(dimensionsItem, (Request<?>)request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (getMetricStatisticsRequest.getStartTime() != null) {
            prefix = "StartTime";
            Date startTime = getMetricStatisticsRequest.getStartTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)startTime));
        }
        if (getMetricStatisticsRequest.getEndTime() != null) {
            prefix = "EndTime";
            Date endTime = getMetricStatisticsRequest.getEndTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)endTime));
        }
        if (getMetricStatisticsRequest.getPeriod() != null) {
            prefix = "Period";
            Integer period = getMetricStatisticsRequest.getPeriod();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)period));
        }
        if (getMetricStatisticsRequest.getStatistics() != null) {
            prefix = "Statistics";
            List<String> statistics = getMetricStatisticsRequest.getStatistics();
            int statisticsIndex = 1;
            String statisticsPrefix = prefix;
            for (String statisticsItem : statistics) {
                prefix = statisticsPrefix + ".member." + statisticsIndex;
                if (statisticsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)statisticsItem));
                }
                ++statisticsIndex;
            }
            prefix = statisticsPrefix;
        }
        if (getMetricStatisticsRequest.getUnit() != null) {
            prefix = "Unit";
            String unit = getMetricStatisticsRequest.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
        return request;
    }
}

