/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.transform.DimensionFilterStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        String prefix;
        if (listMetricsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListMetricsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMetricsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        if (listMetricsRequest.getNamespace() != null) {
            prefix = "Namespace";
            String namespace = listMetricsRequest.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (listMetricsRequest.getMetricName() != null) {
            prefix = "MetricName";
            String metricName = listMetricsRequest.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (listMetricsRequest.getDimensions() != null) {
            prefix = "Dimensions";
            List<DimensionFilter> dimensions = listMetricsRequest.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (DimensionFilter dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionFilterStaxMarshaller.getInstance().marshall(dimensionsItem, (Request<?>)request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (listMetricsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = listMetricsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        return request;
    }
}

