/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.services.cloudwatch.model.transform.DimensionStaxMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.StatisticSetStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

class MetricDatumStaxMarshaller {
    private static MetricDatumStaxMarshaller instance;

    MetricDatumStaxMarshaller() {
    }

    public void marshall(MetricDatum _metricDatum, Request<?> request, String _prefix) {
        String prefix;
        if (_metricDatum.getMetricName() != null) {
            prefix = _prefix + "MetricName";
            String metricName = _metricDatum.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (_metricDatum.getDimensions() != null) {
            prefix = _prefix + "Dimensions";
            List<Dimension> dimensions = _metricDatum.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (Dimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionStaxMarshaller.getInstance().marshall(dimensionsItem, request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (_metricDatum.getTimestamp() != null) {
            prefix = _prefix + "Timestamp";
            Date timestamp = _metricDatum.getTimestamp();
            request.addParameter(prefix, StringUtils.fromDate((Date)timestamp));
        }
        if (_metricDatum.getValue() != null) {
            prefix = _prefix + "Value";
            Double value = _metricDatum.getValue();
            request.addParameter(prefix, StringUtils.fromDouble((Double)value));
        }
        if (_metricDatum.getStatisticValues() != null) {
            prefix = _prefix + "StatisticValues";
            StatisticSet statisticValues = _metricDatum.getStatisticValues();
            StatisticSetStaxMarshaller.getInstance().marshall(statisticValues, request, prefix + ".");
        }
        if (_metricDatum.getUnit() != null) {
            prefix = _prefix + "Unit";
            String unit = _metricDatum.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
    }

    public static MetricDatumStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new MetricDatumStaxMarshaller();
        }
        return instance;
    }
}

