/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.transform.DimensionStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

class MetricStaxMarshaller {
    private static MetricStaxMarshaller instance;

    MetricStaxMarshaller() {
    }

    public void marshall(Metric _metric, Request<?> request, String _prefix) {
        String prefix;
        if (_metric.getNamespace() != null) {
            prefix = _prefix + "Namespace";
            String namespace = _metric.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (_metric.getMetricName() != null) {
            prefix = _prefix + "MetricName";
            String metricName = _metric.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (_metric.getDimensions() != null) {
            prefix = _prefix + "Dimensions";
            List<Dimension> dimensions = _metric.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (Dimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionStaxMarshaller.getInstance().marshall(dimensionsItem, request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
    }

    public static MetricStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStaxMarshaller();
        }
        return instance;
    }
}

