/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.transform.DimensionStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        String prefix;
        if (putMetricAlarmRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutMetricAlarmRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricAlarmRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        if (putMetricAlarmRequest.getAlarmName() != null) {
            prefix = "AlarmName";
            String alarmName = putMetricAlarmRequest.getAlarmName();
            request.addParameter(prefix, StringUtils.fromString((String)alarmName));
        }
        if (putMetricAlarmRequest.getAlarmDescription() != null) {
            prefix = "AlarmDescription";
            String alarmDescription = putMetricAlarmRequest.getAlarmDescription();
            request.addParameter(prefix, StringUtils.fromString((String)alarmDescription));
        }
        if (putMetricAlarmRequest.getActionsEnabled() != null) {
            prefix = "ActionsEnabled";
            Boolean actionsEnabled = putMetricAlarmRequest.getActionsEnabled();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)actionsEnabled));
        }
        if (putMetricAlarmRequest.getOKActions() != null) {
            prefix = "OKActions";
            List<String> oKActions = putMetricAlarmRequest.getOKActions();
            int oKActionsIndex = 1;
            String oKActionsPrefix = prefix;
            for (String oKActionsItem : oKActions) {
                prefix = oKActionsPrefix + ".member." + oKActionsIndex;
                if (oKActionsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)oKActionsItem));
                }
                ++oKActionsIndex;
            }
            prefix = oKActionsPrefix;
        }
        if (putMetricAlarmRequest.getAlarmActions() != null) {
            prefix = "AlarmActions";
            List<String> alarmActions = putMetricAlarmRequest.getAlarmActions();
            int alarmActionsIndex = 1;
            String alarmActionsPrefix = prefix;
            for (String alarmActionsItem : alarmActions) {
                prefix = alarmActionsPrefix + ".member." + alarmActionsIndex;
                if (alarmActionsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)alarmActionsItem));
                }
                ++alarmActionsIndex;
            }
            prefix = alarmActionsPrefix;
        }
        if (putMetricAlarmRequest.getInsufficientDataActions() != null) {
            prefix = "InsufficientDataActions";
            List<String> insufficientDataActions = putMetricAlarmRequest.getInsufficientDataActions();
            int insufficientDataActionsIndex = 1;
            String insufficientDataActionsPrefix = prefix;
            for (String insufficientDataActionsItem : insufficientDataActions) {
                prefix = insufficientDataActionsPrefix + ".member." + insufficientDataActionsIndex;
                if (insufficientDataActionsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)insufficientDataActionsItem));
                }
                ++insufficientDataActionsIndex;
            }
            prefix = insufficientDataActionsPrefix;
        }
        if (putMetricAlarmRequest.getMetricName() != null) {
            prefix = "MetricName";
            String metricName = putMetricAlarmRequest.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (putMetricAlarmRequest.getNamespace() != null) {
            prefix = "Namespace";
            String namespace = putMetricAlarmRequest.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (putMetricAlarmRequest.getStatistic() != null) {
            prefix = "Statistic";
            String statistic = putMetricAlarmRequest.getStatistic();
            request.addParameter(prefix, StringUtils.fromString((String)statistic));
        }
        if (putMetricAlarmRequest.getDimensions() != null) {
            prefix = "Dimensions";
            List<Dimension> dimensions = putMetricAlarmRequest.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (Dimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    DimensionStaxMarshaller.getInstance().marshall(dimensionsItem, (Request<?>)request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (putMetricAlarmRequest.getPeriod() != null) {
            prefix = "Period";
            Integer period = putMetricAlarmRequest.getPeriod();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)period));
        }
        if (putMetricAlarmRequest.getUnit() != null) {
            prefix = "Unit";
            String unit = putMetricAlarmRequest.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
        if (putMetricAlarmRequest.getEvaluationPeriods() != null) {
            prefix = "EvaluationPeriods";
            Integer evaluationPeriods = putMetricAlarmRequest.getEvaluationPeriods();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)evaluationPeriods));
        }
        if (putMetricAlarmRequest.getThreshold() != null) {
            prefix = "Threshold";
            Double threshold = putMetricAlarmRequest.getThreshold();
            request.addParameter(prefix, StringUtils.fromDouble((Double)threshold));
        }
        if (putMetricAlarmRequest.getComparisonOperator() != null) {
            prefix = "ComparisonOperator";
            String comparisonOperator = putMetricAlarmRequest.getComparisonOperator();
            request.addParameter(prefix, StringUtils.fromString((String)comparisonOperator));
        }
        return request;
    }
}

