/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.transform.MetricDatumStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        String prefix;
        if (putMetricDataRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutMetricDataRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        if (putMetricDataRequest.getNamespace() != null) {
            prefix = "Namespace";
            String namespace = putMetricDataRequest.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (putMetricDataRequest.getMetricData() != null) {
            prefix = "MetricData";
            List<MetricDatum> metricData = putMetricDataRequest.getMetricData();
            int metricDataIndex = 1;
            String metricDataPrefix = prefix;
            for (MetricDatum metricDataItem : metricData) {
                prefix = metricDataPrefix + ".member." + metricDataIndex;
                if (metricDataItem != null) {
                    MetricDatumStaxMarshaller.getInstance().marshall(metricDataItem, (Request<?>)request, prefix + ".");
                }
                ++metricDataIndex;
            }
            String string = metricDataPrefix;
        }
        return request;
    }
}

