/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetAlarmStateRequestMarshaller
implements Marshaller<Request<SetAlarmStateRequest>, SetAlarmStateRequest> {
    public Request<SetAlarmStateRequest> marshall(SetAlarmStateRequest setAlarmStateRequest) {
        String prefix;
        if (setAlarmStateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetAlarmStateRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setAlarmStateRequest, "AmazonCloudWatch");
        request.addParameter("Action", "SetAlarmState");
        request.addParameter("Version", "2010-08-01");
        if (setAlarmStateRequest.getAlarmName() != null) {
            prefix = "AlarmName";
            String alarmName = setAlarmStateRequest.getAlarmName();
            request.addParameter(prefix, StringUtils.fromString((String)alarmName));
        }
        if (setAlarmStateRequest.getStateValue() != null) {
            prefix = "StateValue";
            String stateValue = setAlarmStateRequest.getStateValue();
            request.addParameter(prefix, StringUtils.fromString((String)stateValue));
        }
        if (setAlarmStateRequest.getStateReason() != null) {
            prefix = "StateReason";
            String stateReason = setAlarmStateRequest.getStateReason();
            request.addParameter(prefix, StringUtils.fromString((String)stateReason));
        }
        if (setAlarmStateRequest.getStateReasonData() != null) {
            prefix = "StateReasonData";
            String stateReasonData = setAlarmStateRequest.getStateReasonData();
            request.addParameter(prefix, StringUtils.fromString((String)stateReasonData));
        }
        return request;
    }
}

