/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class StatisticSetStaxUnmarshaller
implements Unmarshaller<StatisticSet, StaxUnmarshallerContext> {
    private static StatisticSetStaxUnmarshaller instance;

    StatisticSetStaxUnmarshaller() {
    }

    public StatisticSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        StatisticSet statisticSet = new StatisticSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("SampleCount", targetDepth)) {
                    statisticSet.setSampleCount(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Sum", targetDepth)) {
                    statisticSet.setSum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    statisticSet.setMinimum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Maximum", targetDepth)) continue;
                statisticSet.setMaximum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return statisticSet;
    }

    public static StatisticSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StatisticSetStaxUnmarshaller();
        }
        return instance;
    }
}

