/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;

public class ApacheCommonsLogging
implements Log {
    private Class logClass;
    private String logString;
    private org.apache.commons.logging.Log log;
    private LogFactory.Level level = null;

    public ApacheCommonsLogging(Class logClass) {
        this.logClass = logClass;
        this.log = org.apache.commons.logging.LogFactory.getLog((Class)logClass);
    }

    public ApacheCommonsLogging(String logString) {
        this.logString = logString;
        this.log = org.apache.commons.logging.LogFactory.getLog((String)logString);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled() && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue());
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled() && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue());
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled() && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled() && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue());
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled() && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue());
    }

    @Override
    public void trace(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue()) {
            this.log.trace(message);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue()) {
            this.log.trace(message, t);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue()) {
            this.log.debug(message);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue()) {
            this.log.debug(message, t);
        }
    }

    @Override
    public void info(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue()) {
            this.log.info(message);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue()) {
            this.log.info(message, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue()) {
            this.log.warn(message);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue()) {
            this.log.warn(message, t);
        }
    }

    @Override
    public void error(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue()) {
            this.log.error(message);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue()) {
            this.log.error(message, t);
        }
    }

    @Override
    public void setLevel(LogFactory.Level level) {
        this.level = level;
    }

    private LogFactory.Level getLevel() {
        if (this.level != null) {
            return this.level;
        }
        return LogFactory.getLevel();
    }
}

