/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public enum IOUtils {

    private static final Log logger = LogFactory.getLog(IOUtils.class);
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            output.close();
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(IOUtils.toByteArray(is), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable is, Log log) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Ignore failure in closing the Closeable", ex);
                }
            }
        }
    }

    public static void release(Closeable is, Log log) {
        IOUtils.closeQuietly(is, log);
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        long count = 0L;
        int n = 0;
        while ((n = in.read(buf)) > -1) {
            out.write(buf, 0, n);
            count += (long)n;
        }
        return count;
    }
}

