/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document;

import com.amazonaws.mobileconnectors.dynamodbv2.document.Table;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Document;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import java.util.HashMap;
import java.util.Map;

public class Expression {
    private String expressionStatement;
    private final Map<String, String> expressionAttributeNames = new HashMap<String, String>();
    private final Map<String, DynamoDBEntry> expressionAttributeValues = new HashMap<String, DynamoDBEntry>();

    protected boolean isSet() {
        return this.expressionStatement != null;
    }

    public void addExpressionAttributeNames(String key, String value) {
        this.expressionAttributeNames.put(key, value);
    }

    public Expression withExpressionAttibuteNames(String key, String value) {
        this.addExpressionAttributeNames(key, value);
        return this;
    }

    public void addExpressionAttributeValues(String key, DynamoDBEntry value) {
        this.expressionAttributeValues.put(key, value);
    }

    public Expression withExpressionAttibuteValues(String key, DynamoDBEntry value) {
        this.addExpressionAttributeValues(key, value);
        return this;
    }

    protected void applyExpression(ScanRequest request, Table table) {
        request.setFilterExpression(this.expressionStatement);
        if (this.expressionAttributeNames != null && !this.expressionAttributeNames.isEmpty()) {
            request.setExpressionAttributeNames(new HashMap<String, String>(this.expressionAttributeNames));
        }
        request.setExpressionAttributeValues(Expression.convertToAttributeValues(this.expressionAttributeValues, table));
    }

    protected void applyExpression(DeleteItemRequest request, Table table) {
        request.setConditionExpression(this.expressionStatement);
        if (this.expressionAttributeNames != null && !this.expressionAttributeNames.isEmpty()) {
            request.setExpressionAttributeNames(new HashMap<String, String>(this.expressionAttributeNames));
        }
        request.setExpressionAttributeValues(Expression.convertToAttributeValues(this.expressionAttributeValues, table));
    }

    protected void applyExpression(PutItemRequest request, Table table) {
        request.setConditionExpression(this.expressionStatement);
        if (this.expressionAttributeNames != null && !this.expressionAttributeNames.isEmpty()) {
            request.setExpressionAttributeNames(new HashMap<String, String>(this.expressionAttributeNames));
        }
        request.setExpressionAttributeValues(Expression.convertToAttributeValues(this.expressionAttributeValues, table));
    }

    protected void applyExpression(UpdateItemRequest request, Table table) {
        request.setConditionExpression(this.expressionStatement);
        if (this.expressionAttributeNames != null && !this.expressionAttributeNames.isEmpty()) {
            request.setExpressionAttributeNames(new HashMap<String, String>(this.expressionAttributeNames));
        }
        request.setExpressionAttributeValues(Expression.convertToAttributeValues(this.expressionAttributeValues, table));
    }

    protected static void applyExpression(QueryRequest request, Table table, Expression keyExpression, Expression filterExpression) {
        if (keyExpression == null) {
            keyExpression = new Expression();
        }
        if (filterExpression == null) {
            filterExpression = new Expression();
        }
        if (!keyExpression.isSet() && !filterExpression.isSet()) {
            return;
        }
        if (keyExpression.isSet()) {
            request.setKeyConditionExpression(keyExpression.expressionStatement);
        }
        if (filterExpression.isSet()) {
            request.setFilterExpression(filterExpression.expressionStatement);
        }
        Map<String, String> keyExpressionAtrtibuteNames = keyExpression.expressionAttributeNames;
        Map<String, String> filterExpressionAttributeNames = filterExpression.expressionAttributeNames;
        HashMap<String, String> combinedExpressionAttributeNames = new HashMap<String, String>();
        combinedExpressionAttributeNames.putAll(keyExpressionAtrtibuteNames);
        combinedExpressionAttributeNames.putAll(filterExpressionAttributeNames);
        if (!combinedExpressionAttributeNames.isEmpty()) {
            request.setExpressionAttributeNames(combinedExpressionAttributeNames);
        }
        Document keyExpressionAttributeValues = new Document(keyExpression.expressionAttributeValues);
        Document filterExpressionAttributeValues = new Document(filterExpression.expressionAttributeValues);
        Document combinedKeyExpressionAttributeValues = new Document(keyExpressionAttributeValues);
        combinedKeyExpressionAttributeValues.putAll(filterExpressionAttributeValues);
        request.setExpressionAttributeValues(Expression.convertToAttributeValues(combinedKeyExpressionAttributeValues, table));
    }

    protected static Map<String, AttributeValue> convertToAttributeValues(Map<String, DynamoDBEntry> valueMap, Table table) {
        HashMap<String, AttributeValue> convertedValues = new HashMap<String, AttributeValue>();
        if (valueMap != null) {
            for (Map.Entry<String, DynamoDBEntry> kvp : valueMap.entrySet()) {
                String attributeName = kvp.getKey();
                DynamoDBEntry entry = kvp.getValue();
                if (entry == null) {
                    convertedValues.put(attributeName, new AttributeValue().withNULL(Boolean.valueOf(true)));
                    continue;
                }
                convertedValues.put(attributeName, entry.convertToAttributeValue());
            }
        }
        return convertedValues;
    }

    public String getExpressionStatement() {
        return this.expressionStatement;
    }

    public void setExpressionStatement(String expressionStatement) {
        this.expressionStatement = expressionStatement;
    }
}

