/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Filter {
    protected Map<String, FilterCondition> conditions = new HashMap<String, FilterCondition>();

    public void addCondition(String attributeName, ComparisonOperator comparisonOperator, List<AttributeValue> attributeValues) {
        if (attributeValues == null) {
            throw new IllegalArgumentException("attribute values is null");
        }
        if (comparisonOperator == null) {
            throw new IllegalArgumentException("comparison operator is null");
        }
        this.conditions.put(attributeName, new FilterCondition(comparisonOperator, attributeValues));
    }

    public void addCondition(String attributeName, FilterCondition filterCondition) {
        this.conditions.put(attributeName, filterCondition);
    }

    protected static List<AttributeValue> convertToAttributeValues(DynamoDBEntry[] values) {
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        for (DynamoDBEntry value : values) {
            AttributeValue nativeValue = value.convertToAttributeValue();
            if (nativeValue == null) continue;
            attributes.add(nativeValue);
        }
        return attributes;
    }

    public Map<String, Condition> toConditions() {
        HashMap<String, Condition> dic = new HashMap<String, Condition>();
        for (Map.Entry<String, FilterCondition> kvp : this.conditions.entrySet()) {
            String name = kvp.getKey();
            FilterCondition fc = kvp.getValue();
            Condition condition = fc.toCondition(name);
            dic.put(name, condition);
        }
        return dic;
    }

    protected class FilterCondition {
        private final List<AttributeValue> attributeValues;
        private final ComparisonOperator comparisonOperator;

        public FilterCondition(ComparisonOperator comparisonOperator, List<AttributeValue> attributeValues) {
            this.comparisonOperator = comparisonOperator;
            this.attributeValues = attributeValues;
        }

        public Condition toCondition(String attributeName) {
            Condition condition = new Condition().withAttributeValueList(this.attributeValues).withComparisonOperator(this.comparisonOperator);
            return condition;
        }
    }
}

