/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document;

import com.amazonaws.mobileconnectors.dynamodbv2.document.Filter;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueryFilter
extends Filter {
    protected QueryFilter() {
    }

    protected QueryFilter(QueryFilter baseFilter) {
        for (Map.Entry kvp : baseFilter.conditions.entrySet()) {
            String key = (String)kvp.getKey();
            Filter.FilterCondition condition = (Filter.FilterCondition)kvp.getValue();
            this.addCondition(key, condition);
        }
    }

    public QueryFilter(String attributeName, ComparisonOperator op, List<AttributeValue> values) {
        this.addCondition(attributeName, op, values);
    }

    public QueryFilter(String attributeName, Filter.FilterCondition filterCondition) {
        this.addCondition(attributeName, filterCondition);
    }

    public QueryFilter(String attributeName, ComparisonOperator op, DynamoDBEntry ... values) {
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        for (DynamoDBEntry entry : values) {
            attributeValues.add(entry.convertToAttributeValue());
        }
        this.addCondition(attributeName, op, attributeValues);
    }
}

