/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document;

import com.amazonaws.mobileconnectors.dynamodbv2.document.Expression;
import com.amazonaws.mobileconnectors.dynamodbv2.document.Filter;
import com.amazonaws.mobileconnectors.dynamodbv2.document.QueryFilter;
import com.amazonaws.mobileconnectors.dynamodbv2.document.Table;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Document;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Search {
    private Table table;
    private String tableName;
    private boolean collectResults = true;
    private int limit = 1;
    private Expression keyExpression;
    private Expression filterExpression;
    private Filter filter;
    private ConditionalOperator conditionalOperator;
    private List<String> attributesToGet;
    private boolean isConsistentRead;
    private boolean isBackwardSearch;
    private boolean isDone = false;
    private Map<String, AttributeValue> nextKey;
    private final List<Document> matches = new ArrayList<Document>();
    private int totalSegments;
    private int segment;
    private int count = -1;
    private String indexName;
    private Select select;
    private final SearchType searchType;

    protected Search(SearchType searchType) {
        this.searchType = searchType;
    }

    protected Search() {
        this.searchType = SearchType.QUERY;
    }

    protected Search withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    protected Search withCollectResults(boolean collectResults) {
        this.collectResults = collectResults;
        return this;
    }

    protected Search withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    protected Search withKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
        return this;
    }

    protected Search withFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    protected Search withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    protected Search withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
        return this;
    }

    protected Search withAttributesToGet(List<String> attributesToGet) {
        this.attributesToGet = attributesToGet;
        return this;
    }

    protected Search withIsConsistentRead(boolean isConsistentRead) {
        this.isConsistentRead = isConsistentRead;
        return this;
    }

    protected Search withIsBackwardSearch(boolean isBackwardSearch) {
        this.isBackwardSearch = isBackwardSearch;
        return this;
    }

    protected Search withNextKey(Map<String, AttributeValue> nextKey) {
        this.nextKey = nextKey;
        return this;
    }

    protected Search withTotalSegments(int totalSegments) {
        this.totalSegments = totalSegments;
        return this;
    }

    protected Search withSegment(int segment) {
        this.segment = segment;
        return this;
    }

    protected Search withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    protected Search withSelect(Select select) {
        this.select = select;
        return this;
    }

    protected Search withTable(Table table) {
        this.table = table;
        return this;
    }

    public List<Document> getNextResultSet() {
        switch (this.searchType) {
            case QUERY: {
                return this.getNextQueryResultSet();
            }
            case SCAN: {
                return this.getNextScanResultSet();
            }
        }
        throw new IllegalStateException("search type other than scan or query");
    }

    private List<Document> getNextScanResultSet() {
        ArrayList<Document> returnValue = new ArrayList<Document>();
        ScanRequest request = new ScanRequest();
        request.withExclusiveStartKey(this.nextKey).withAttributesToGet(this.attributesToGet).withLimit(Integer.valueOf(this.limit)).withTableName(this.tableName).withConsistentRead(Boolean.valueOf(this.isConsistentRead));
        if (this.select != null) {
            request.withSelect(this.select);
        }
        if (this.filter != null) {
            request.withScanFilter(this.filter.toConditions());
        }
        if (!StringUtils.isBlank((CharSequence)this.indexName)) {
            request.withIndexName(this.indexName);
        }
        if (this.filterExpression != null && this.filterExpression.isSet()) {
            this.filterExpression.applyExpression(request, this.table);
        }
        if (request.getScanFilter() != null && request.getScanFilter().size() > 1) {
            request.setConditionalOperator(this.conditionalOperator);
        }
        if (this.totalSegments != 0) {
            request.withTotalSegments(Integer.valueOf(this.totalSegments)).withSegment(Integer.valueOf(this.segment));
        }
        Table.appendDynamoDBDocumentUserAgentString(request);
        ScanResult result = this.table.getClient().scan(request);
        for (Map item : result.getItems()) {
            Document doc = Document.fromAttributeMap(item);
            returnValue.add(doc);
            if (!this.collectResults) continue;
            this.matches.add(doc);
        }
        this.nextKey = result.getLastEvaluatedKey();
        if (this.nextKey == null || this.nextKey.size() == 0) {
            this.isDone = true;
        }
        return returnValue;
    }

    private List<Document> getNextQueryResultSet() {
        ArrayList<Document> returnValue = new ArrayList<Document>();
        QueryRequest request = new QueryRequest();
        request.withExclusiveStartKey(this.nextKey).withAttributesToGet(this.attributesToGet).withLimit(Integer.valueOf(this.limit)).withTableName(this.tableName).withConsistentRead(Boolean.valueOf(this.isConsistentRead)).withIndexName(this.indexName);
        if (this.select != null) {
            request.withSelect(this.select);
        }
        Expression.applyExpression(request, this.table, this.keyExpression, this.filterExpression);
        if (this.filter != null) {
            Map<String, Condition> keyConditions = this.getKeyConditions((QueryFilter)this.filter, request.getIndexName());
            Map<String, Condition> filterConditions = this.getFilterConditions((QueryFilter)this.filter, request.getIndexName());
            if (!keyConditions.isEmpty()) {
                request.withKeyConditions(keyConditions);
            }
            if (!filterConditions.isEmpty()) {
                request.withQueryFilter(filterConditions);
            }
        } else {
            request.withKeyConditions(null).withQueryFilter(null);
        }
        if (request.getQueryFilter() != null && request.getQueryFilter().size() > 1) {
            request.withConditionalOperator(this.conditionalOperator);
        } else {
            request.withConditionalOperator((String)null);
        }
        Table.appendDynamoDBDocumentUserAgentString(request);
        QueryResult result = this.table.getClient().query(request);
        for (Map item : result.getItems()) {
            Document doc = Document.fromAttributeMap(item);
            returnValue.add(doc);
            if (!this.collectResults) continue;
            this.matches.add(doc);
        }
        this.nextKey = result.getLastEvaluatedKey();
        if (this.nextKey == null || this.nextKey.size() == 0) {
            this.isDone = true;
        }
        return returnValue;
    }

    public List<Document> getAllResults() {
        ArrayList<Document> returnValue = new ArrayList<Document>();
        while (!this.isDone) {
            returnValue.addAll(this.getNextResultSet());
        }
        return returnValue;
    }

    private Map<String, Condition> getKeyConditions(QueryFilter filter, String indexName) {
        HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
        Map<String, Condition> conditions = filter.toConditions();
        for (Map.Entry<String, Condition> entry : conditions.entrySet()) {
            String attributeName = entry.getKey();
            Condition condition = entry.getValue();
            if (!Search.isKeyAttribute(this.table, indexName, attributeName)) continue;
            keyConditions.put(attributeName, condition);
        }
        return keyConditions;
    }

    private Map<String, Condition> getFilterConditions(QueryFilter filter, String indexName) {
        HashMap<String, Condition> filterConditions = new HashMap<String, Condition>();
        Map<String, Condition> conditions = filter.toConditions();
        for (Map.Entry<String, Condition> entry : conditions.entrySet()) {
            String attributeName = entry.getKey();
            Condition condition = entry.getValue();
            if (Search.isKeyAttribute(this.table, indexName, attributeName)) continue;
            filterConditions.put(attributeName, condition);
        }
        return filterConditions;
    }

    private static boolean isKeyAttribute(Table table, String indexName, String attributeName) {
        GlobalSecondaryIndexDescription gsi = null;
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return table.getKeys().containsKey(attributeName);
        }
        if (table.getGlobalSecondaryIndexes().get(indexName) != null) {
            gsi = table.getGlobalSecondaryIndexes().get(indexName);
            Iterator iterator = gsi.getKeySchema().iterator();
            if (iterator.hasNext()) {
                KeySchemaElement element = (KeySchemaElement)iterator.next();
                return Search.isKeyAttribute(element, attributeName);
            }
        } else if (table.getLocalSecondaryIndexes().get(indexName) != null) {
            LocalSecondaryIndexDescription lsi = table.getLocalSecondaryIndexes().get(indexName);
            Iterator iterator = lsi.getKeySchema().iterator();
            if (iterator.hasNext()) {
                KeySchemaElement element = (KeySchemaElement)iterator.next();
                return Search.isKeyAttribute(element, attributeName);
            }
        } else {
            throw new IllegalStateException(String.format("Unable to locate index %s on table %s", indexName, table.getTableName()));
        }
        return false;
    }

    private static boolean isKeyAttribute(KeySchemaElement element, String attributeName) {
        return element.getAttributeName().equals(attributeName);
    }

    public int getCount() {
        if (this.isDone && this.collectResults) {
            return this.matches.size();
        }
        if (this.count != -1) {
            return this.count;
        }
        switch (this.searchType) {
            case SCAN: {
                ScanRequest request = new ScanRequest();
                request.withExclusiveStartKey(this.nextKey).withTableName(this.tableName).withScanFilter(this.filter.toConditions()).withSelect(Select.COUNT).withConsistentRead(Boolean.valueOf(this.isConsistentRead));
                if (!StringUtils.isBlank((CharSequence)this.indexName)) {
                    request.withIndexName(this.indexName);
                }
                if (this.filterExpression != null && this.filterExpression.isSet()) {
                    this.filterExpression.applyExpression(request, this.table);
                }
                if (request.getScanFilter() != null && request.getScanFilter().size() > 1) {
                    request.setConditionalOperator(this.conditionalOperator);
                }
                if (this.totalSegments != 0) {
                    request.withTotalSegments(Integer.valueOf(this.totalSegments)).withSegment(Integer.valueOf(this.segment));
                }
                Table.appendDynamoDBDocumentUserAgentString(request);
                ScanResult result = this.table.getClient().scan(request);
                this.count = this.matches.size() + result.getCount();
                return this.count;
            }
            case QUERY: {
                QueryRequest request = new QueryRequest();
                request.withExclusiveStartKey(this.nextKey).withTableName(this.tableName).withSelect(Select.COUNT).withConsistentRead(Boolean.valueOf(this.isConsistentRead)).withIndexName(this.indexName);
                Expression.applyExpression(request, this.table, this.keyExpression, this.filterExpression);
                Map<String, Condition> keyConditions = this.getKeyConditions((QueryFilter)this.filter, request.getIndexName());
                Map<String, Condition> filterConditions = this.getFilterConditions((QueryFilter)this.filter, request.getIndexName());
                request.withKeyConditions(keyConditions).withQueryFilter(filterConditions);
                if (request.getQueryFilter() != null && request.getQueryFilter().size() > 1) {
                    request.withConditionalOperator(this.conditionalOperator);
                }
                Table.appendDynamoDBDocumentUserAgentString(request);
                QueryResult result = this.table.getClient().query(request);
                this.count = this.matches.size() + result.getCount();
                return this.count;
            }
        }
        throw new IllegalStateException("search type other than scan or query");
    }

    public static enum SearchType {
        QUERY("QUERY"),
        SCAN("SCAN");

        private final String type;

        private SearchType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

