/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.mobileconnectors.dynamodbv2.document.DeleteItemOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.Expression;
import com.amazonaws.mobileconnectors.dynamodbv2.document.GetItemOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.PutItemOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.QueryFilter;
import com.amazonaws.mobileconnectors.dynamodbv2.document.QueryOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.ScanFilter;
import com.amazonaws.mobileconnectors.dynamodbv2.document.ScanOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.Search;
import com.amazonaws.mobileconnectors.dynamodbv2.document.UpdateItemOperationConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Document;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Primitive;
import com.amazonaws.mobileconnectors.dynamodbv2.document.internal.Key;
import com.amazonaws.mobileconnectors.dynamodbv2.document.internal.KeyDescription;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Table {
    private final AmazonDynamoDB client;
    private final String tableName;
    private TableDescription tableDescription;
    private Map<String, KeyDescription> keys = new HashMap<String, KeyDescription>();
    private Map<String, GlobalSecondaryIndexDescription> globalSecondaryIndexes = new HashMap<String, GlobalSecondaryIndexDescription>();
    private Map<String, LocalSecondaryIndexDescription> localSecondaryIndexes = new HashMap<String, LocalSecondaryIndexDescription>();
    private List<String> localSecondaryIndexNames = new ArrayList<String>();
    private List<String> globalSecondaryIndexNames = new ArrayList<String>();
    private List<String> hashKeys = new ArrayList<String>();
    private List<String> rangeKeys = new ArrayList<String>();
    private List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();

    public Table(AmazonDynamoDB client, String tableName) {
        this(client, tableName, null);
    }

    public Table(AmazonDynamoDB client, String tableName, TableDescription tableDescription) {
        if (client == null) {
            throw new IllegalArgumentException("client must be specified");
        }
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("table name must not be null or empty");
        }
        this.client = client;
        this.tableName = tableName;
        this.tableDescription = tableDescription;
    }

    protected static <X extends AmazonWebServiceRequest> X appendDynamoDBDocumentUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("DynamoDBv2Document/" + VersionInfoUtils.getVersion());
        return request;
    }

    public static Table loadTable(AmazonDynamoDB client, String tableName) {
        Table table = new Table(client, tableName);
        table.loadTableDescription();
        return table;
    }

    public void loadTableDescription() {
        this.clear();
        DescribeTableRequest request = Table.appendDynamoDBDocumentUserAgentString(new DescribeTableRequest(this.tableName));
        DescribeTableResult result = this.client.describeTable(request);
        this.tableDescription = result.getTable();
        block0: for (KeySchemaElement element : this.tableDescription.getKeySchema()) {
            String keyName = element.getAttributeName();
            for (AttributeDefinition ad : this.tableDescription.getAttributeDefinitions()) {
                if (!ad.getAttributeName().equals(keyName)) continue;
                KeyDescription kd = new KeyDescription();
                kd.setHash("HASH".equalsIgnoreCase(element.getKeyType()));
                kd.setType(Table.getType(ad.getAttributeType()));
                if (kd.isHash()) {
                    this.hashKeys.add(keyName);
                } else {
                    this.rangeKeys.add(keyName);
                }
                this.keys.put(keyName, kd);
                continue block0;
            }
        }
        if (this.tableDescription.getLocalSecondaryIndexes() != null) {
            for (LocalSecondaryIndexDescription index : this.tableDescription.getLocalSecondaryIndexes()) {
                this.localSecondaryIndexes.put(index.getIndexName(), index);
                this.localSecondaryIndexNames.add(index.getIndexName());
            }
        }
        if (this.tableDescription.getGlobalSecondaryIndexes() != null) {
            for (LocalSecondaryIndexDescription index : this.tableDescription.getGlobalSecondaryIndexes()) {
                this.globalSecondaryIndexes.put(index.getIndexName(), (GlobalSecondaryIndexDescription)index);
                this.globalSecondaryIndexNames.add(index.getIndexName());
            }
        }
        for (AttributeDefinition ad : this.tableDescription.getAttributeDefinitions()) {
            this.attributes.add(ad);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableDescription getTableDescription() {
        return this.tableDescription;
    }

    public Map<String, KeyDescription> getKeys() {
        return this.keys;
    }

    public Map<String, GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Map<String, LocalSecondaryIndexDescription> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public List<String> getLocalSecondaryIndexNames() {
        return this.localSecondaryIndexNames;
    }

    public List<String> getGlobalSecondaryIndexNames() {
        return this.globalSecondaryIndexNames;
    }

    public List<String> getHashKeys() {
        return this.hashKeys;
    }

    public List<String> getRangeKeys() {
        return this.rangeKeys;
    }

    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    protected void setKeys(Map<String, KeyDescription> keys) {
        this.keys = keys;
    }

    protected void setGlobalSecondaryIndexes(Map<String, GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
        this.globalSecondaryIndexes = globalSecondaryIndexes;
    }

    protected void setLocalSecondaryIndexes(Map<String, LocalSecondaryIndexDescription> localSecondaryIndexes) {
        this.localSecondaryIndexes = localSecondaryIndexes;
    }

    protected void setLocalSecondaryIndexNames(List<String> localSecondaryIndexNames) {
        this.localSecondaryIndexNames = localSecondaryIndexNames;
    }

    protected void setGlobalSecondaryIndexNames(List<String> globalSecondaryIndexNames) {
        this.globalSecondaryIndexNames = globalSecondaryIndexNames;
    }

    protected void setHashKeys(List<String> hashKeys) {
        this.hashKeys = hashKeys;
    }

    protected void setRangeKeys(List<String> rangeKeys) {
        this.rangeKeys = rangeKeys;
    }

    protected void setAttributes(List<AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    private static Primitive.DynamoDBPrimitiveType getType(String attributeType) {
        if ("N".equalsIgnoreCase(attributeType)) {
            return Primitive.DynamoDBPrimitiveType.Number;
        }
        if ("S".equalsIgnoreCase(attributeType)) {
            return Primitive.DynamoDBPrimitiveType.String;
        }
        if ("B".equalsIgnoreCase(attributeType)) {
            return Primitive.DynamoDBPrimitiveType.Binary;
        }
        throw new IllegalStateException("Unknown attribute type");
    }

    public Document putItem(Document document) {
        return this.putItem(document, null);
    }

    public Document putItem(Document document, PutItemOperationConfig config) {
        PutItemRequest request = new PutItemRequest();
        request.setTableName(this.tableName);
        request.setItem(this.toAttributeMap(document));
        if (config != null && config.getReturnValue().compareTo((Enum)ReturnValue.ALL_OLD) == 0) {
            request.setReturnValues(ReturnValue.ALL_OLD);
        }
        Table.appendDynamoDBDocumentUserAgentString(request);
        PutItemResult result = this.client.putItem(request);
        Document ret = null;
        if (config != null && config.getReturnValue().compareTo((Enum)ReturnValue.ALL_OLD) == 0) {
            Map values = result.getAttributes();
            ret = this.fromAttributeMap(values);
            ret.commit();
        }
        return ret;
    }

    public Document getItem(Primitive hashKey) {
        return this.getItem(this.makeKey(hashKey, null), null);
    }

    public Document getItem(Primitive hashKey, Primitive rangeKey) {
        return this.getItem(this.makeKey(hashKey, rangeKey), null);
    }

    public Document getItem(Primitive hashKey, GetItemOperationConfig config) {
        return this.getItem(this.makeKey(hashKey, null), config);
    }

    public Document getItem(Primitive hashKey, Primitive rangeKey, GetItemOperationConfig config) {
        return this.getItem(this.makeKey(hashKey, rangeKey), config);
    }

    private Document getItem(Key key, GetItemOperationConfig config) {
        GetItemRequest request = new GetItemRequest(this.tableName, (Map)key);
        if (config != null) {
            request.setConsistentRead(Boolean.valueOf(config.isConsistentRead()));
            if (config.getAttributesToGet() != null && config.getAttributesToGet().size() > 0) {
                request.setAttributesToGet(config.getAttributesToGet());
            }
        }
        Table.appendDynamoDBDocumentUserAgentString(request);
        GetItemResult response = this.client.getItem(request);
        Map item = response.getItem();
        if (item == null || item.size() == 0) {
            return null;
        }
        Document returnDocument = this.fromAttributeMap(item);
        returnDocument.commit();
        return returnDocument;
    }

    public Document deleteItem(Primitive hashKey) {
        return this.deleteItem(hashKey, (DeleteItemOperationConfig)null);
    }

    public Document deleteItem(Primitive hashKey, Primitive rangeKey) {
        return this.deleteItem(hashKey, rangeKey, null);
    }

    public Document deleteItem(Primitive hashKey, DeleteItemOperationConfig config) {
        return this.deleteItem(this.makeKey(hashKey, null), config);
    }

    public Document deleteItem(Primitive hashKey, Primitive rangeKey, DeleteItemOperationConfig config) {
        return this.deleteItem(this.makeKey(hashKey, rangeKey), config);
    }

    private Document deleteItem(Key key, DeleteItemOperationConfig config) {
        DeleteItemRequest request = new DeleteItemRequest(this.tableName, (Map)key);
        if (config != null) {
            request.setReturnValues(config.getReturnValue());
        }
        Table.appendDynamoDBDocumentUserAgentString(request);
        DeleteItemResult result = this.client.deleteItem(request);
        Document returnDocument = this.fromAttributeMap(result.getAttributes());
        returnDocument.commit();
        return returnDocument;
    }

    public Document updateItem(Document doc, UpdateItemOperationConfig config) {
        return this.updateItem(doc, this.makeKey(doc), config);
    }

    public Document updateItem(Document doc, Primitive hashKey, UpdateItemOperationConfig config) {
        return this.updateItem(doc, this.makeKey(hashKey, null), config);
    }

    public Document updateItem(Document doc, Primitive hashKey, Primitive rangeKey, UpdateItemOperationConfig config) {
        return this.updateItem(doc, this.makeKey(hashKey, rangeKey), config);
    }

    public Search query(Primitive hashKey, QueryFilter filter) {
        String hashKeyName = this.hashKeys.get(0);
        QueryFilter fullFilter = new QueryFilter(filter);
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        attributes.add(hashKey.convertToAttributeValue());
        fullFilter.addCondition(hashKeyName, ComparisonOperator.EQ, attributes);
        return this.query(fullFilter);
    }

    public Search query(Primitive hashKey, Expression filterExpression) {
        String hashKeyName = this.hashKeys.get(0);
        QueryFilter hashKeyFilter = new QueryFilter();
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        attributes.add(hashKey.convertToAttributeValue());
        hashKeyFilter.addCondition(hashKeyName, ComparisonOperator.EQ, attributes);
        QueryOperationConfig config = new QueryOperationConfig();
        config.withFilter(hashKeyFilter).withFilterExpression(filterExpression);
        return this.query(config);
    }

    public Search query(Primitive hashKey) {
        String hashKeyName = this.hashKeys.get(0);
        QueryFilter hashKeyFilter = new QueryFilter();
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        attributes.add(hashKey.convertToAttributeValue());
        hashKeyFilter.addCondition(hashKeyName, ComparisonOperator.EQ, attributes);
        QueryOperationConfig config = new QueryOperationConfig();
        config.withFilter(hashKeyFilter);
        return this.query(config);
    }

    public Search query(QueryFilter filter) {
        return this.query(new QueryOperationConfig().withFilter(filter));
    }

    public Search query(QueryOperationConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        Search search = new Search(Search.SearchType.QUERY);
        search.withAttributesToGet(config.getAttributesToGet()).withCollectResults(config.isCollectResults()).withConditionalOperator(config.getConditionalOperator()).withLimit(config.getLimit() <= 0 ? Integer.MAX_VALUE : config.getLimit()).withFilterExpression(config.getFilterExpression() == null ? null : config.getFilterExpression()).withIndexName(config.getIndexName()).withTableName(this.tableName).withIsConsistentRead(config.isConsistentRead()).withIsBackwardSearch(config.isBackwardSearch()).withKeyExpression(config.getKeyExpression()).withSelect(config.getSelect()).withTable(this);
        if (config.getFilter() != null && !config.getFilter().conditions.isEmpty()) {
            search.withFilter(config.getFilter());
        }
        return search;
    }

    public Search scan(ScanFilter filter) {
        return this.scan(new ScanOperationConfig().withFilter(filter));
    }

    public Search scan(Expression filterExpression) {
        ScanOperationConfig config = new ScanOperationConfig();
        config.withFilterExpression(filterExpression);
        return this.scan(config);
    }

    public Search scan(ScanOperationConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        Search search = new Search(Search.SearchType.SCAN);
        search.withAttributesToGet(config.getAttributesToGet()).withCollectResults(config.isCollectResults()).withConditionalOperator(config.getConditionalOperator()).withLimit(config.getLimit() <= 0 ? Integer.MAX_VALUE : config.getLimit()).withFilter(config.getFilter()).withFilterExpression(config.getFilterExpression()).withIndexName(config.getIndexName()).withTableName(this.tableName).withIsConsistentRead(config.isConsistentRead()).withSelect(config.getSelect()).withTable(this);
        if (config.getTotalSegments() != 0) {
            search.withTotalSegments(config.getTotalSegments()).withSegment(config.getSegment());
        }
        return search;
    }

    private boolean haveKeysChanged(Document doc) {
        Set<String> keyNames = this.keys.keySet();
        for (String keyName : keyNames) {
            if (!doc.hasAttributeChanged(keyName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, AttributeValue> toAttributeMap(Document document) {
        Map<String, AttributeValue> ret = document.toAttributeMap();
        return ret;
    }

    private Map<String, AttributeValueUpdate> toAttributeUpdateMap(Document document, boolean changeAttributesOnly) {
        Map<String, AttributeValueUpdate> ret = document.toAttributeUpdateMap(changeAttributesOnly);
        return ret;
    }

    private Document fromAttributeMap(Map<String, AttributeValue> attributes) {
        return Document.fromAttributeMap(attributes);
    }

    private Document updateItem(Document doc, Key key, UpdateItemOperationConfig config) {
        boolean updateChangedAttributes = !this.haveKeysChanged(doc);
        Map<String, AttributeValueUpdate> attributeUpdateValues = this.toAttributeUpdateMap(doc, updateChangedAttributes);
        for (String keyName : this.keys.keySet()) {
            attributeUpdateValues.remove(keyName);
        }
        UpdateItemRequest updateRequest = new UpdateItemRequest();
        updateRequest.setTableName(this.tableName);
        updateRequest.setKey((Map)key);
        updateRequest.setAttributeUpdates(attributeUpdateValues.size() == 0 ? null : attributeUpdateValues);
        updateRequest.setReturnValues(config.getReturnValue());
        Table.appendDynamoDBDocumentUserAgentString(updateRequest);
        UpdateItemResult result = this.client.updateItem(updateRequest);
        doc.commit();
        if (config.getReturnValue() != ReturnValue.NONE) {
            return this.fromAttributeMap(result.getAttributes());
        }
        return null;
    }

    private void clear() {
        this.keys = new HashMap<String, KeyDescription>();
        this.hashKeys = new ArrayList<String>();
        this.rangeKeys = new ArrayList<String>();
        this.localSecondaryIndexes = new HashMap<String, LocalSecondaryIndexDescription>();
        this.localSecondaryIndexNames = new ArrayList<String>();
        this.globalSecondaryIndexes = new HashMap<String, GlobalSecondaryIndexDescription>();
        this.globalSecondaryIndexNames = new ArrayList<String>();
        this.attributes = new ArrayList<AttributeDefinition>();
    }

    private Key makeKey(Document doc) {
        Key key = new Key();
        for (Map.Entry<String, KeyDescription> kvp : this.keys.entrySet()) {
            String keyName = kvp.getKey();
            KeyDescription description = kvp.getValue();
            DynamoDBEntry value = doc.get(keyName);
            if (value == null) {
                throw new IllegalStateException("no value for key " + keyName);
            }
            Primitive primitive = value.asPrimitive();
            if (primitive == null) {
                throw new IllegalStateException("Key attribute " + keyName + " must be a Primitive type");
            }
            if (primitive.getType() != description.getType()) {
                throw new IllegalStateException("Key attribute " + keyName + " must be of type " + (Object)((Object)description.getType()));
            }
            key.put(keyName, primitive.convertToAttributeValue());
        }
        return key;
    }

    private Key makeKey(Primitive hashKey, Primitive rangeKey) {
        Key key = new Key();
        if (this.hashKeys.size() != 1) {
            throw new IllegalStateException("no hashkeys in table");
        }
        String hashKeyName = this.hashKeys.get(0);
        KeyDescription keyDescription = this.keys.get(hashKeyName);
        if (keyDescription.getType() != hashKey.getType()) {
            throw new IllegalStateException("hash key type does not match the one in table defination");
        }
        AttributeValue av = hashKey.convertToAttributeValue();
        key.put(hashKeyName, av);
        if (rangeKey == null && this.rangeKeys.size() > 0) {
            throw new IllegalStateException("range key not specificed for a table with range keys");
        }
        if (rangeKey != null) {
            String rangeKeyName = this.rangeKeys.get(0);
            KeyDescription kd = this.keys.get(rangeKeyName);
            if (kd.getType() != rangeKey.getType()) {
                throw new IllegalStateException("range key type does not match that of table defination");
            }
            AttributeValue rangeKeyAttributeValue = rangeKey.convertToAttributeValue();
            key.put(rangeKeyName, rangeKeyAttributeValue);
        }
        return key;
    }

    protected AmazonDynamoDB getClient() {
        return this.client;
    }

    protected void setTableDescription(TableDescription tableDescription) {
        this.tableDescription = tableDescription;
    }
}

