/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBBool;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBList;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBNull;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Primitive;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.PrimitiveList;
import com.amazonaws.mobileconnectors.dynamodbv2.document.internal.JsonUtils;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
extends DynamoDBEntry
implements Map<String, DynamoDBEntry> {
    private final Map<String, DynamoDBEntry> originalValues;
    private final Map<String, DynamoDBEntry> currentValues;

    public Document() {
        this.originalValues = new HashMap<String, DynamoDBEntry>();
        this.currentValues = new HashMap<String, DynamoDBEntry>();
    }

    public Document(Map<String, DynamoDBEntry> values) {
        this.currentValues = new HashMap<String, DynamoDBEntry>(values);
        this.originalValues = new HashMap<String, DynamoDBEntry>();
    }

    @Override
    public DynamoDBEntry put(String key, DynamoDBEntry value) {
        return this.currentValues.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.currentValues.containsKey(key);
    }

    @Override
    public DynamoDBEntry get(Object key) {
        return this.currentValues.get(key);
    }

    @Override
    public DynamoDBEntry remove(Object key) {
        return this.currentValues.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.currentValues.keySet();
    }

    @Override
    public Set<Map.Entry<String, DynamoDBEntry>> entrySet() {
        return this.currentValues.entrySet();
    }

    @Override
    public int size() {
        return this.currentValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentValues.isEmpty();
    }

    @Override
    public boolean containsValue(Object paramObject) {
        return this.currentValues.containsValue(paramObject);
    }

    @Override
    public void putAll(Map<? extends String, ? extends DynamoDBEntry> m) {
        this.currentValues.putAll(m);
    }

    @Override
    public void clear() {
        this.currentValues.clear();
    }

    @Override
    public Collection<DynamoDBEntry> values() {
        return this.currentValues.values();
    }

    public static Document fromJson(String json) {
        return JsonUtils.fromJson(json);
    }

    public static String toJson(Document document) throws IOException {
        return JsonUtils.toJson(document);
    }

    public static String toJson(Document document, boolean prettyPrint) throws IOException {
        return JsonUtils.toJson(document, prettyPrint);
    }

    @Override
    public AttributeValue convertToAttributeValue() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, DynamoDBEntry> item : this.currentValues.entrySet()) {
            String key = item.getKey();
            DynamoDBEntry entry = item.getValue();
            AttributeValue entryAttributeValue = entry.convertToAttributeValue();
            if (entryAttributeValue == null) continue;
            map.put(key, entryAttributeValue);
        }
        AttributeValue mapAttributeValue = new AttributeValue();
        mapAttributeValue.setM(map);
        return mapAttributeValue;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> ret = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, DynamoDBEntry> kvp : this.currentValues.entrySet()) {
            String attributeName = kvp.getKey();
            DynamoDBEntry entry = kvp.getValue();
            AttributeValue value = entry.convertToAttributeValue();
            if (value == null) continue;
            ret.put(attributeName, value);
        }
        return ret;
    }

    public Map<String, AttributeValueUpdate> toAttributeUpdateMap(boolean changeAttributesOnly) {
        HashMap<String, AttributeValueUpdate> ret = new HashMap<String, AttributeValueUpdate>();
        for (Map.Entry<String, DynamoDBEntry> kvp : this.currentValues.entrySet()) {
            String attributeName = kvp.getKey();
            DynamoDBEntry entry = kvp.getValue();
            AttributeValueUpdate value = entry.convertToAttributeUpdateValue();
            if (value == null || changeAttributesOnly && !this.hasAttributeChanged(attributeName)) continue;
            ret.put(attributeName, value);
        }
        return ret;
    }

    public static Document fromAttributeMap(Map<String, AttributeValue> attributes) {
        Document doc = new Document();
        if (attributes != null) {
            for (Map.Entry<String, AttributeValue> attribute : attributes.entrySet()) {
                String key = attribute.getKey();
                AttributeValue value = attribute.getValue();
                DynamoDBEntry convertedValue = Document.attributeValueToDynamoDBEntry(value);
                if (convertedValue == null) continue;
                doc.put(key, convertedValue);
            }
        }
        return doc;
    }

    public boolean hasAttributeChanged(String attributeName) {
        DynamoDBEntry originalEntry = this.originalValues.get(attributeName);
        DynamoDBEntry currentEntry = this.currentValues.get(attributeName);
        if (originalEntry == null || currentEntry == null) {
            return false;
        }
        boolean flag = !originalEntry.equals(currentEntry);
        return flag;
    }

    private static DynamoDBEntry attributeValueToDynamoDBEntry(AttributeValue value) {
        Primitive primitive = Document.toPrimitive(value);
        if (primitive != null) {
            return primitive;
        }
        PrimitiveList primitiveList = Document.toPrimitiveList(value);
        if (primitiveList != null) {
            return primitiveList;
        }
        DynamoDBBool bool = Document.toDynamoDBBool(value);
        if (bool != null) {
            return bool;
        }
        DynamoDBNull nullEntry = Document.toDynamoDBNull(value);
        if (nullEntry != null) {
            return nullEntry;
        }
        DynamoDBList listEntry = Document.toDynamoDBList(value);
        if (listEntry != null) {
            return listEntry;
        }
        Document document = Document.toDynamoDBDocument(value);
        if (document != null) {
            return document;
        }
        return null;
    }

    private static Primitive toPrimitive(AttributeValue attributeValue) {
        Primitive primitive = null;
        if (attributeValue.getS() != null) {
            primitive = new Primitive(attributeValue.getS());
        } else if (attributeValue.getN() != null) {
            primitive = new Primitive(attributeValue.getN(), true);
        } else if (attributeValue.getB() != null) {
            primitive = new Primitive(attributeValue.getB());
        }
        return primitive;
    }

    private static PrimitiveList toPrimitiveList(AttributeValue attributeValue) {
        PrimitiveList primitiveList;
        block4: {
            Primitive primitive;
            block5: {
                block3: {
                    primitiveList = null;
                    primitive = null;
                    if (attributeValue.getSS() == null) break block3;
                    primitiveList = new PrimitiveList(Primitive.DynamoDBPrimitiveType.String);
                    for (String s : attributeValue.getSS()) {
                        primitive = new Primitive(s);
                        primitiveList.add(primitive);
                    }
                    break block4;
                }
                if (attributeValue.getNS() == null) break block5;
                primitiveList = new PrimitiveList(Primitive.DynamoDBPrimitiveType.Number);
                for (String s : attributeValue.getNS()) {
                    primitive = new Primitive(s, true);
                    primitiveList.add(primitive);
                }
                break block4;
            }
            if (attributeValue.getBS() == null) break block4;
            primitiveList = new PrimitiveList(Primitive.DynamoDBPrimitiveType.Binary);
            for (ByteBuffer b : attributeValue.getBS()) {
                primitive = new Primitive(b);
                primitiveList.add(primitive);
            }
        }
        return primitiveList;
    }

    private static DynamoDBBool toDynamoDBBool(AttributeValue attributeValue) {
        if (attributeValue.getBOOL() != null) {
            return new DynamoDBBool(attributeValue.getBOOL());
        }
        return null;
    }

    private static DynamoDBNull toDynamoDBNull(AttributeValue attributeValue) {
        if (attributeValue != null && attributeValue.getNULL() != null) {
            return DynamoDBNull.NULL;
        }
        return null;
    }

    private static DynamoDBList toDynamoDBList(AttributeValue attributeValue) {
        DynamoDBList list = null;
        if (attributeValue.getL() != null) {
            list = new DynamoDBList();
            List listAttributes = attributeValue.getL();
            for (AttributeValue av : listAttributes) {
                DynamoDBEntry entry = Document.attributeValueToDynamoDBEntry(av);
                list.add(entry);
            }
        }
        return list;
    }

    private static Document toDynamoDBDocument(AttributeValue attributeValue) {
        Document document = null;
        if (attributeValue.getM() != null) {
            document = new Document();
            Map mapAttributes = attributeValue.getM();
            for (Map.Entry entry : mapAttributes.entrySet()) {
                document.put((String)entry.getKey(), Document.attributeValueToDynamoDBEntry((AttributeValue)entry.getValue()));
            }
        }
        return document;
    }

    @Override
    public void put(String key, String value) {
        this.put(key, new Primitive(value));
    }

    public Document withString(String key, String value) {
        this.put(key, value);
        return this;
    }

    @Override
    public <T> void put(String key, Set<T> set) {
        PrimitiveList pl = new PrimitiveList();
        pl.addAll(set);
        this.put(key, pl);
    }

    public <T> Document withSet(String key, Set<T> set) {
        this.put(key, set);
        return this;
    }

    @Override
    public void put(String key, Number value) {
        this.put(key, new Primitive(value));
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, new DynamoDBBool(value));
    }

    @Override
    public Document asDocument() {
        return this;
    }

    public void commit() {
        this.originalValues.clear();
        for (Map.Entry<String, DynamoDBEntry> entry : this.currentValues.entrySet()) {
            this.originalValues.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equal(this.currentValues, other.currentValues);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.currentValues});
    }
}

