/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Document;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBList;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Primitive;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.PrimitiveList;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.google.gson.Gson;
import java.nio.ByteBuffer;

public abstract class DynamoDBEntry {
    private static final Gson GSON = new Gson();

    public abstract AttributeValue convertToAttributeValue();

    public AttributeValueUpdate convertToAttributeUpdateValue() {
        AttributeValue attributeValue = this.convertToAttributeValue();
        AttributeValueUpdate attributeUpdate = new AttributeValueUpdate();
        if (attributeValue == null) {
            attributeUpdate.setAction(AttributeAction.DELETE);
        } else {
            attributeUpdate.setAction(AttributeAction.PUT);
            attributeUpdate.setValue(attributeValue);
        }
        return attributeUpdate;
    }

    public Boolean asBoolean() {
        throw new ClassCastException("Not a boolean");
    }

    public String asString() {
        throw new ClassCastException("Not a string");
    }

    public ByteBuffer asByteBuffer() {
        throw new ClassCastException("Not a byte buffer");
    }

    public Number asNumber() {
        throw new ClassCastException("Not a number");
    }

    public Integer asInt() {
        throw new ClassCastException("Not an integer");
    }

    public Double asDouble() {
        throw new ClassCastException("Not a double");
    }

    public Long asLong() {
        throw new ClassCastException("Not a Long");
    }

    public Float asFloat() {
        throw new ClassCastException("Not a float");
    }

    public PrimitiveList asPrimitiveList() {
        throw new ClassCastException("Not an array");
    }

    public DynamoDBList asDynamoDBList() {
        throw new ClassCastException("Not a DynamoDB List");
    }

    public Document asDocument() {
        throw new ClassCastException("Not a Document");
    }

    public Primitive asPrimitive() {
        throw new ClassCastException("Not a primitive");
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }
}

