/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DynamoDBList
extends DynamoDBEntry
implements List<DynamoDBEntry> {
    private final List<DynamoDBEntry> entries = new ArrayList<DynamoDBEntry>();

    @Override
    public boolean add(DynamoDBEntry entry) {
        return this.entries.add(entry);
    }

    public DynamoDBEntry get(Integer index) {
        return this.entries.get(index);
    }

    @Override
    public AttributeValue convertToAttributeValue() {
        ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
        for (DynamoDBEntry item : this.entries) {
            AttributeValue attributeValue = item.convertToAttributeValue();
            list.add(attributeValue);
        }
        AttributeValue listAttributeValue = new AttributeValue();
        listAttributeValue.setL(list);
        return listAttributeValue;
    }

    public List<DynamoDBEntry> getEntries() {
        return this.entries;
    }

    public void addAll(List<DynamoDBEntry> args) {
        this.entries.addAll(args);
    }

    @Override
    public DynamoDBList asDynamoDBList() {
        return this;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean contains(Object paramObject) {
        return this.entries.contains(paramObject);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Iterator<DynamoDBEntry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] paramArrayOfT) {
        return this.entries.toArray(paramArrayOfT);
    }

    @Override
    public boolean remove(Object paramObject) {
        return this.entries.remove(paramObject);
    }

    @Override
    public boolean containsAll(Collection<?> paramCollection) {
        return this.entries.containsAll(paramCollection);
    }

    @Override
    public boolean addAll(Collection<? extends DynamoDBEntry> paramCollection) {
        return this.entries.addAll(paramCollection);
    }

    @Override
    public boolean addAll(int paramInt, Collection<? extends DynamoDBEntry> paramCollection) {
        return this.entries.addAll(paramInt, paramCollection);
    }

    @Override
    public boolean removeAll(Collection<?> paramCollection) {
        return this.entries.removeAll(paramCollection);
    }

    @Override
    public boolean retainAll(Collection<?> paramCollection) {
        return this.entries.retainAll(paramCollection);
    }

    @Override
    public DynamoDBEntry get(int paramInt) {
        return this.entries.get(paramInt);
    }

    @Override
    public DynamoDBEntry set(int paramInt, DynamoDBEntry paramE) {
        return this.entries.set(paramInt, paramE);
    }

    @Override
    public void add(int paramInt, DynamoDBEntry paramE) {
        this.entries.add(paramInt, paramE);
    }

    @Override
    public DynamoDBEntry remove(int paramInt) {
        return this.entries.remove(paramInt);
    }

    @Override
    public int indexOf(Object paramObject) {
        return this.entries.indexOf(paramObject);
    }

    @Override
    public int lastIndexOf(Object paramObject) {
        return this.entries.lastIndexOf(paramObject);
    }

    @Override
    public ListIterator<DynamoDBEntry> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public ListIterator<DynamoDBEntry> listIterator(int paramInt) {
        return this.listIterator(paramInt);
    }

    @Override
    public List<DynamoDBEntry> subList(int paramInt1, int paramInt2) {
        return this.entries.subList(paramInt1, paramInt2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamoDBList other = (DynamoDBList)obj;
        return Objects.equal(this.entries, other.entries);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entries});
    }
}

