/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Primitive;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PrimitiveList
extends DynamoDBEntry {
    private final Primitive.DynamoDBPrimitiveType type;
    private final List<Primitive> entries;

    public PrimitiveList() {
        this(Primitive.DynamoDBPrimitiveType.String);
    }

    public PrimitiveList(Primitive.DynamoDBPrimitiveType type) {
        this.type = type;
        this.entries = new ArrayList<Primitive>();
    }

    public void add(String value) {
        if (this.type != Primitive.DynamoDBPrimitiveType.String) {
            throw new IllegalArgumentException("Invalid parameter type string");
        }
        this.entries.add(new Primitive(value));
    }

    public void add(Number value) {
        if (this.type != Primitive.DynamoDBPrimitiveType.Number) {
            throw new IllegalArgumentException("Invalid parameter type Number");
        }
        this.entries.add(new Primitive(value));
    }

    public void add(ByteBuffer value) {
        if (this.type != Primitive.DynamoDBPrimitiveType.Binary) {
            throw new IllegalArgumentException("Invalid parameter type ByteBuffer");
        }
        this.entries.add(new Primitive(value));
    }

    public <T> void addAll(Set<T> set) {
        for (T t : set) {
            if (t instanceof String) {
                this.entries.add(new Primitive((String)t));
                continue;
            }
            if (t instanceof Number) {
                this.entries.add(new Primitive((Number)t));
                continue;
            }
            if (t instanceof ByteBuffer) {
                this.entries.add(new Primitive((ByteBuffer)t));
                continue;
            }
            throw new IllegalArgumentException("Invalid type = " + t.getClass());
        }
    }

    public void add(Primitive value) {
        this.entries.add(value);
    }

    public Primitive get(Integer index) {
        return this.entries.get(index);
    }

    @Override
    public AttributeValue convertToAttributeValue() {
        if (this.entries == null || this.entries.size() == 0) {
            return null;
        }
        AttributeValue av = new AttributeValue();
        if (this.type != Primitive.DynamoDBPrimitiveType.Binary) {
            ArrayList<String> values = new ArrayList<String>();
            for (Primitive entry : this.entries) {
                values.add(entry.asString());
            }
            if (this.type == Primitive.DynamoDBPrimitiveType.Number) {
                av.setNS(values);
            } else {
                av.setSS(values);
            }
        } else {
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
            for (Primitive entry : this.entries) {
                values.add(entry.asByteBuffer());
            }
            av.setBS(values);
        }
        return av;
    }

    public List<Primitive> getEntries() {
        return this.entries;
    }

    public Primitive.DynamoDBPrimitiveType getType() {
        return this.type;
    }

    @Override
    public PrimitiveList asPrimitiveList() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimitiveList other = (PrimitiveList)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal(this.entries, other.entries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.entries});
    }
}

