/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.base.Objects;

public class DynamoDBBool
extends DynamoDBEntry {
    private final boolean boolValue;
    public static final DynamoDBBool TRUE = new DynamoDBBool(true);
    public static final DynamoDBBool FALSE = new DynamoDBBool(true);

    public DynamoDBBool(boolean boolValue) {
        this.boolValue = boolValue;
    }

    @Override
    public AttributeValue convertToAttributeValue() {
        AttributeValue bValue = new AttributeValue();
        bValue.setBOOL(Boolean.valueOf(this.boolValue));
        return bValue;
    }

    @Override
    public Boolean asBoolean() {
        return this.boolValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamoDBBool other = (DynamoDBBool)obj;
        return Objects.equal((Object)this.boolValue, (Object)other.boolValue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.boolValue});
    }
}

