/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.datatype;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParseException;

public class Primitive
extends DynamoDBEntry {
    private final DynamoDBPrimitiveType type;
    private final Object value;

    public Primitive() {
        this(null, DynamoDBPrimitiveType.String);
    }

    public Primitive(String value) {
        this((Object)value, DynamoDBPrimitiveType.String);
    }

    public Primitive(Number value) {
        this(value, DynamoDBPrimitiveType.Number);
    }

    public Primitive(String value, boolean saveAsNumeric) {
        this((Object)value, saveAsNumeric ? DynamoDBPrimitiveType.Number : DynamoDBPrimitiveType.String);
    }

    public Primitive(Integer value, boolean saveAsNumeric) {
        this((Object)value, saveAsNumeric ? DynamoDBPrimitiveType.Number : DynamoDBPrimitiveType.String);
    }

    public Primitive(ByteBuffer value) {
        this(value, DynamoDBPrimitiveType.Binary);
    }

    private Primitive(Object value, DynamoDBPrimitiveType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public String asString() {
        if (this.type != DynamoDBPrimitiveType.Binary) {
            return String.valueOf(this.value);
        }
        return super.asString();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        if (this.type == DynamoDBPrimitiveType.Binary) {
            return (ByteBuffer)this.value;
        }
        return super.asByteBuffer();
    }

    @Override
    public Number asNumber() {
        if (this.type == DynamoDBPrimitiveType.Number) {
            if (this.value instanceof String) {
                try {
                    return NumberFormat.getInstance().parse((String)this.value);
                }
                catch (ParseException e) {
                    throw new NumberFormatException("cannot parse " + this.value + " as number");
                }
            }
            return (Number)this.value;
        }
        return super.asNumber();
    }

    @Override
    public Integer asInt() {
        if (this.type == DynamoDBPrimitiveType.Number) {
            if (this.value instanceof String) {
                return Integer.parseInt((String)this.value);
            }
            return (Integer)this.value;
        }
        return super.asInt();
    }

    @Override
    public Double asDouble() {
        if (this.type == DynamoDBPrimitiveType.Number) {
            if (this.value instanceof String) {
                return Double.parseDouble((String)this.value);
            }
            return (Double)this.value;
        }
        return super.asDouble();
    }

    @Override
    public Long asLong() {
        if (this.type == DynamoDBPrimitiveType.Number) {
            if (this.value instanceof String) {
                return Long.parseLong((String)this.value);
            }
            return (Long)this.value;
        }
        return super.asLong();
    }

    @Override
    public Float asFloat() {
        if (this.type == DynamoDBPrimitiveType.Number) {
            if (this.value instanceof String) {
                return Float.valueOf(Float.parseFloat((String)this.value));
            }
            return (Float)this.value;
        }
        return super.asFloat();
    }

    @Override
    public AttributeValue convertToAttributeValue() {
        if (this.value == null) {
            return null;
        }
        AttributeValue av = new AttributeValue();
        switch (this.type) {
            case String: {
                av.setS(String.valueOf(this.value));
                break;
            }
            case Number: {
                av.setN(String.valueOf(this.value));
                break;
            }
            case Binary: {
                av.setB((ByteBuffer)this.value);
                break;
            }
            default: {
                throw new IllegalStateException("invalid primitive type");
            }
        }
        return av;
    }

    public DynamoDBPrimitiveType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Primitive other = (Primitive)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.value});
    }

    @Override
    public Primitive asPrimitive() {
        return this;
    }

    public static enum DynamoDBPrimitiveType {
        String,
        Number,
        Binary;

    }
}

