/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.document.internal;

import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Document;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBBool;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBEntry;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBList;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.DynamoDBNull;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.Primitive;
import com.amazonaws.mobileconnectors.dynamodbv2.document.datatype.PrimitiveList;
import com.amazonaws.util.Base64;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Map;

public final class JsonUtils {
    public static Document fromJson(String jsonText) {
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonText).getAsJsonObject();
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException("expected object as JSON root");
        }
        Document doc = (Document)JsonUtils.toEntry((JsonElement)json);
        if (doc == null) {
            throw new IllegalStateException();
        }
        return doc;
    }

    public static String toJson(DynamoDBEntry entry) throws IOException {
        return JsonUtils.toJson(entry, false);
    }

    public static String toJson(DynamoDBEntry entry, boolean prettyPrint) throws IOException {
        StringWriter jsonString = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)jsonString);
        if (prettyPrint) {
            writer.setIndent("  ");
        }
        JsonUtils.writeJson(entry, writer);
        writer.close();
        return jsonString.toString();
    }

    private static void writeJson(DynamoDBEntry entry, JsonWriter writer) throws IOException {
        if (entry instanceof Document) {
            writer.beginObject();
            Document doc = (Document)entry;
            for (Map.Entry<String, DynamoDBEntry> entry2 : doc.entrySet()) {
                String key = entry2.getKey();
                DynamoDBEntry value = entry2.getValue();
                writer.name(key);
                JsonUtils.writeJson(value, writer);
            }
            writer.endObject();
            return;
        }
        if (entry instanceof Primitive) {
            Primitive p = (Primitive)entry;
            JsonUtils.writePrimitive(p.getType(), writer, p);
            return;
        }
        if (entry instanceof PrimitiveList) {
            PrimitiveList pl = (PrimitiveList)entry;
            writer.beginArray();
            for (DynamoDBEntry dynamoDBEntry : pl.getEntries()) {
                JsonUtils.writePrimitive(pl.getType(), writer, dynamoDBEntry);
            }
            writer.endArray();
            return;
        }
        if (entry instanceof DynamoDBList) {
            DynamoDBList pl = (DynamoDBList)entry;
            writer.beginArray();
            for (DynamoDBEntry dynamoDBEntry : pl.getEntries()) {
                JsonUtils.writeJson(dynamoDBEntry, writer);
            }
            writer.endArray();
            return;
        }
        if (entry instanceof DynamoDBBool) {
            writer.value(((DynamoDBBool)entry).asBoolean().booleanValue());
            return;
        }
        if (entry instanceof DynamoDBNull) {
            writer.nullValue();
            return;
        }
        throw new JsonParseException("unable to convert to json " + entry);
    }

    private static void writePrimitive(Primitive.DynamoDBPrimitiveType type, JsonWriter writer, Object value) throws IOException {
        DynamoDBEntry entry = (DynamoDBEntry)value;
        switch (type) {
            case String: {
                writer.value(entry.asString());
                break;
            }
            case Number: {
                writer.value(entry.asNumber());
                break;
            }
            case Binary: {
                ByteBuffer bb = entry.asByteBuffer();
                String base64 = Base64.encodeAsString((byte[])bb.array());
                writer.value(base64);
                break;
            }
        }
    }

    private static DynamoDBEntry toEntry(JsonElement data) {
        if (data == null || data.isJsonNull()) {
            return DynamoDBNull.NULL;
        }
        if (data.isJsonObject()) {
            Document doc = new Document();
            for (Map.Entry entry : data.getAsJsonObject().entrySet()) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                doc.put(key, JsonUtils.toEntry(element));
            }
            return doc;
        }
        if (data.isJsonArray()) {
            DynamoDBList list = new DynamoDBList();
            JsonArray array = data.getAsJsonArray();
            for (JsonElement type : array) {
                list.add(JsonUtils.toEntry(type));
            }
            return list;
        }
        JsonPrimitive primitive = data.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return new DynamoDBBool(primitive.getAsBoolean());
        }
        if (primitive.isString()) {
            return new Primitive(primitive.getAsString());
        }
        if (primitive.isNumber()) {
            return new Primitive(primitive.getAsNumber());
        }
        throw new JsonParseException("unable to parse json for key " + data.toString());
    }
}

