/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.json.AwsJsonWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    AttributeValueJsonMarshaller() {
    }

    public void marshall(AttributeValue attributeValue, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (attributeValue.getS() != null) {
            String s = attributeValue.getS();
            jsonWriter.name("S");
            jsonWriter.value(s);
        }
        if (attributeValue.getN() != null) {
            String n = attributeValue.getN();
            jsonWriter.name("N");
            jsonWriter.value(n);
        }
        if (attributeValue.getB() != null) {
            ByteBuffer b = attributeValue.getB();
            jsonWriter.name("B");
            jsonWriter.value(b);
        }
        if (attributeValue.getSS() != null) {
            List<String> sS = attributeValue.getSS();
            jsonWriter.name("SS");
            jsonWriter.beginArray();
            for (String string : sS) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (attributeValue.getNS() != null) {
            List<String> nS = attributeValue.getNS();
            jsonWriter.name("NS");
            jsonWriter.beginArray();
            for (String string : nS) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (attributeValue.getBS() != null) {
            List<ByteBuffer> bS = attributeValue.getBS();
            jsonWriter.name("BS");
            jsonWriter.beginArray();
            for (ByteBuffer byteBuffer : bS) {
                if (byteBuffer == null) continue;
                jsonWriter.value(byteBuffer);
            }
            jsonWriter.endArray();
        }
        if (attributeValue.getM() != null) {
            Map<String, AttributeValue> m = attributeValue.getM();
            jsonWriter.name("M");
            jsonWriter.beginObject();
            for (Map.Entry entry : m.entrySet()) {
                AttributeValue mValue = (AttributeValue)entry.getValue();
                if (mValue == null) continue;
                jsonWriter.name((String)entry.getKey());
                AttributeValueJsonMarshaller.getInstance().marshall(mValue, jsonWriter);
            }
            jsonWriter.endObject();
        }
        if (attributeValue.getL() != null) {
            List<AttributeValue> l = attributeValue.getL();
            jsonWriter.name("L");
            jsonWriter.beginArray();
            for (AttributeValue attributeValue2 : l) {
                if (attributeValue2 == null) continue;
                AttributeValueJsonMarshaller.getInstance().marshall(attributeValue2, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (attributeValue.getNULL() != null) {
            Boolean nULL = attributeValue.getNULL();
            jsonWriter.name("NULL");
            jsonWriter.value(nULL.booleanValue());
        }
        if (attributeValue.getBOOL() != null) {
            Boolean bOOL = attributeValue.getBOOL();
            jsonWriter.name("BOOL");
            jsonWriter.value(bOOL.booleanValue());
        }
        jsonWriter.endObject();
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

