/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueUpdateJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ExpectedAttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateItemRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateItemRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.UpdateItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateItemRequest.getTableName() != null) {
                String tableName = updateItemRequest.getTableName();
                jsonWriter.name("TableName");
                jsonWriter.value(tableName);
            }
            if (updateItemRequest.getKey() != null) {
                Map<String, AttributeValue> key = updateItemRequest.getKey();
                jsonWriter.name("Key");
                jsonWriter.beginObject();
                for (Map.Entry<String, Serializable> entry : key.entrySet()) {
                    AttributeValue keyValue = (AttributeValue)entry.getValue();
                    if (keyValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(keyValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getAttributeUpdates() != null) {
                Map<String, AttributeValueUpdate> attributeUpdates = updateItemRequest.getAttributeUpdates();
                jsonWriter.name("AttributeUpdates");
                jsonWriter.beginObject();
                for (Map.Entry<String, Serializable> entry : attributeUpdates.entrySet()) {
                    AttributeValueUpdate attributeUpdatesValue = (AttributeValueUpdate)entry.getValue();
                    if (attributeUpdatesValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    AttributeValueUpdateJsonMarshaller.getInstance().marshall(attributeUpdatesValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpected() != null) {
                Map<String, ExpectedAttributeValue> expected = updateItemRequest.getExpected();
                jsonWriter.name("Expected");
                jsonWriter.beginObject();
                for (Map.Entry<String, Serializable> entry : expected.entrySet()) {
                    ExpectedAttributeValue expectedValue = (ExpectedAttributeValue)entry.getValue();
                    if (expectedValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    ExpectedAttributeValueJsonMarshaller.getInstance().marshall(expectedValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getConditionalOperator() != null) {
                String conditionalOperator = updateItemRequest.getConditionalOperator();
                jsonWriter.name("ConditionalOperator");
                jsonWriter.value(conditionalOperator);
            }
            if (updateItemRequest.getReturnValues() != null) {
                String returnValues = updateItemRequest.getReturnValues();
                jsonWriter.name("ReturnValues");
                jsonWriter.value(returnValues);
            }
            if (updateItemRequest.getReturnConsumedCapacity() != null) {
                String returnConsumedCapacity = updateItemRequest.getReturnConsumedCapacity();
                jsonWriter.name("ReturnConsumedCapacity");
                jsonWriter.value(returnConsumedCapacity);
            }
            if (updateItemRequest.getReturnItemCollectionMetrics() != null) {
                String returnItemCollectionMetrics = updateItemRequest.getReturnItemCollectionMetrics();
                jsonWriter.name("ReturnItemCollectionMetrics");
                jsonWriter.value(returnItemCollectionMetrics);
            }
            if (updateItemRequest.getUpdateExpression() != null) {
                String updateExpression = updateItemRequest.getUpdateExpression();
                jsonWriter.name("UpdateExpression");
                jsonWriter.value(updateExpression);
            }
            if (updateItemRequest.getConditionExpression() != null) {
                String conditionExpression = updateItemRequest.getConditionExpression();
                jsonWriter.name("ConditionExpression");
                jsonWriter.value(conditionExpression);
            }
            if (updateItemRequest.getExpressionAttributeNames() != null) {
                Map<String, String> expressionAttributeNames = updateItemRequest.getExpressionAttributeNames();
                jsonWriter.name("ExpressionAttributeNames");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : expressionAttributeNames.entrySet()) {
                    String expressionAttributeNamesValue = (String)entry.getValue();
                    if (expressionAttributeNamesValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    jsonWriter.value(expressionAttributeNamesValue);
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpressionAttributeValues() != null) {
                Map<String, AttributeValue> expressionAttributeValues = updateItemRequest.getExpressionAttributeValues();
                jsonWriter.name("ExpressionAttributeValues");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : expressionAttributeValues.entrySet()) {
                    AttributeValue expressionAttributeValuesValue = (AttributeValue)entry.getValue();
                    if (expressionAttributeValuesValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

