/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.Endpoint;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EndpointJsonUnmarshaller
implements Unmarshaller<Endpoint, JsonUnmarshallerContext> {
    private static EndpointJsonUnmarshaller instance;

    EndpointJsonUnmarshaller() {
    }

    public Endpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        Endpoint endpoint = new Endpoint();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Address")) {
                endpoint.setAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CachePeriodInMinutes")) {
                endpoint.setCachePeriodInMinutes(SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return endpoint;
    }

    public static EndpointJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointJsonUnmarshaller();
        }
        return instance;
    }
}

