/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexInfo;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class LocalSecondaryIndexInfoJsonMarshaller {
    private static LocalSecondaryIndexInfoJsonMarshaller instance;

    LocalSecondaryIndexInfoJsonMarshaller() {
    }

    public void marshall(LocalSecondaryIndexInfo localSecondaryIndexInfo, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (localSecondaryIndexInfo.getIndexName() != null) {
            String indexName = localSecondaryIndexInfo.getIndexName();
            jsonWriter.name("IndexName");
            jsonWriter.value(indexName);
        }
        if (localSecondaryIndexInfo.getKeySchema() != null) {
            List<KeySchemaElement> keySchema = localSecondaryIndexInfo.getKeySchema();
            jsonWriter.name("KeySchema");
            jsonWriter.beginArray();
            for (KeySchemaElement keySchemaItem : keySchema) {
                if (keySchemaItem == null) continue;
                KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (localSecondaryIndexInfo.getProjection() != null) {
            Projection projection = localSecondaryIndexInfo.getProjection();
            jsonWriter.name("Projection");
            ProjectionJsonMarshaller.getInstance().marshall(projection, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static LocalSecondaryIndexInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalSecondaryIndexInfoJsonMarshaller();
        }
        return instance;
    }
}

