/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.SourceTableDetails;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class SourceTableDetailsJsonMarshaller {
    private static SourceTableDetailsJsonMarshaller instance;

    SourceTableDetailsJsonMarshaller() {
    }

    public void marshall(SourceTableDetails sourceTableDetails, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (sourceTableDetails.getTableName() != null) {
            String tableName = sourceTableDetails.getTableName();
            jsonWriter.name("TableName");
            jsonWriter.value(tableName);
        }
        if (sourceTableDetails.getTableId() != null) {
            String tableId = sourceTableDetails.getTableId();
            jsonWriter.name("TableId");
            jsonWriter.value(tableId);
        }
        if (sourceTableDetails.getTableArn() != null) {
            String tableArn = sourceTableDetails.getTableArn();
            jsonWriter.name("TableArn");
            jsonWriter.value(tableArn);
        }
        if (sourceTableDetails.getTableSizeBytes() != null) {
            Long tableSizeBytes = sourceTableDetails.getTableSizeBytes();
            jsonWriter.name("TableSizeBytes");
            jsonWriter.value((Number)tableSizeBytes);
        }
        if (sourceTableDetails.getKeySchema() != null) {
            List<KeySchemaElement> keySchema = sourceTableDetails.getKeySchema();
            jsonWriter.name("KeySchema");
            jsonWriter.beginArray();
            for (KeySchemaElement keySchemaItem : keySchema) {
                if (keySchemaItem == null) continue;
                KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (sourceTableDetails.getTableCreationDateTime() != null) {
            Date tableCreationDateTime = sourceTableDetails.getTableCreationDateTime();
            jsonWriter.name("TableCreationDateTime");
            jsonWriter.value(tableCreationDateTime);
        }
        if (sourceTableDetails.getProvisionedThroughput() != null) {
            ProvisionedThroughput provisionedThroughput = sourceTableDetails.getProvisionedThroughput();
            jsonWriter.name("ProvisionedThroughput");
            ProvisionedThroughputJsonMarshaller.getInstance().marshall(provisionedThroughput, jsonWriter);
        }
        if (sourceTableDetails.getItemCount() != null) {
            Long itemCount = sourceTableDetails.getItemCount();
            jsonWriter.name("ItemCount");
            jsonWriter.value((Number)itemCount);
        }
        jsonWriter.endObject();
    }

    public static SourceTableDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SourceTableDetailsJsonMarshaller();
        }
        return instance;
    }
}

