/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.SSEDescription;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class SSEDescriptionJsonUnmarshaller
implements Unmarshaller<SSEDescription, JsonUnmarshallerContext> {
    private static SSEDescriptionJsonUnmarshaller instance;

    SSEDescriptionJsonUnmarshaller() {
    }

    public SSEDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        SSEDescription sSEDescription = new SSEDescription();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Status")) {
                sSEDescription.setStatus(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("SSEType")) {
                sSEDescription.setSSEType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("KMSMasterKeyArn")) {
                sSEDescription.setKMSMasterKeyArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return sSEDescription;
    }

    public static SSEDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SSEDescriptionJsonUnmarshaller();
        }
        return instance;
    }
}

