/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.TimeToLiveSpecification;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.transform.TimeToLiveSpecificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateTimeToLiveRequestMarshaller
implements Marshaller<Request<UpdateTimeToLiveRequest>, UpdateTimeToLiveRequest> {
    public Request<UpdateTimeToLiveRequest> marshall(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        if (updateTimeToLiveRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateTimeToLiveRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTimeToLiveRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.UpdateTimeToLive";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateTimeToLiveRequest.getTableName() != null) {
                String tableName = updateTimeToLiveRequest.getTableName();
                jsonWriter.name("TableName");
                jsonWriter.value(tableName);
            }
            if (updateTimeToLiveRequest.getTimeToLiveSpecification() != null) {
                TimeToLiveSpecification timeToLiveSpecification = updateTimeToLiveRequest.getTimeToLiveSpecification();
                jsonWriter.name("TimeToLiveSpecification");
                TimeToLiveSpecificationJsonMarshaller.getInstance().marshall(timeToLiveSpecification, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

