/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.CancelSpotFleetRequestsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CancelSpotFleetRequestsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<CancelSpotFleetRequestsRequest> {
    private ListWithAutoConstructFlag<String> spotFleetRequestIds;
    private Boolean terminateInstances;

    public List<String> getSpotFleetRequestIds() {
        if (this.spotFleetRequestIds == null) {
            this.spotFleetRequestIds = new ListWithAutoConstructFlag();
            this.spotFleetRequestIds.setAutoConstruct(true);
        }
        return this.spotFleetRequestIds;
    }

    public void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
        if (spotFleetRequestIds == null) {
            this.spotFleetRequestIds = null;
            return;
        }
        ListWithAutoConstructFlag spotFleetRequestIdsCopy = new ListWithAutoConstructFlag(spotFleetRequestIds.size());
        spotFleetRequestIdsCopy.addAll(spotFleetRequestIds);
        this.spotFleetRequestIds = spotFleetRequestIdsCopy;
    }

    public CancelSpotFleetRequestsRequest withSpotFleetRequestIds(String ... spotFleetRequestIds) {
        if (this.getSpotFleetRequestIds() == null) {
            this.setSpotFleetRequestIds(new ArrayList<String>(spotFleetRequestIds.length));
        }
        for (String value : spotFleetRequestIds) {
            this.getSpotFleetRequestIds().add(value);
        }
        return this;
    }

    public CancelSpotFleetRequestsRequest withSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
        if (spotFleetRequestIds == null) {
            this.spotFleetRequestIds = null;
        } else {
            ListWithAutoConstructFlag spotFleetRequestIdsCopy = new ListWithAutoConstructFlag(spotFleetRequestIds.size());
            spotFleetRequestIdsCopy.addAll(spotFleetRequestIds);
            this.spotFleetRequestIds = spotFleetRequestIdsCopy;
        }
        return this;
    }

    public Boolean isTerminateInstances() {
        return this.terminateInstances;
    }

    public void setTerminateInstances(Boolean terminateInstances) {
        this.terminateInstances = terminateInstances;
    }

    public CancelSpotFleetRequestsRequest withTerminateInstances(Boolean terminateInstances) {
        this.terminateInstances = terminateInstances;
        return this;
    }

    public Boolean getTerminateInstances() {
        return this.terminateInstances;
    }

    @Override
    public Request<CancelSpotFleetRequestsRequest> getDryRunRequest() {
        Request<CancelSpotFleetRequestsRequest> request = new CancelSpotFleetRequestsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpotFleetRequestIds() != null) {
            sb.append("SpotFleetRequestIds: " + this.getSpotFleetRequestIds() + ",");
        }
        if (this.isTerminateInstances() != null) {
            sb.append("TerminateInstances: " + this.isTerminateInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpotFleetRequestIds() == null ? 0 : this.getSpotFleetRequestIds().hashCode());
        hashCode = 31 * hashCode + (this.isTerminateInstances() == null ? 0 : this.isTerminateInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsRequest)) {
            return false;
        }
        CancelSpotFleetRequestsRequest other = (CancelSpotFleetRequestsRequest)obj;
        if (other.getSpotFleetRequestIds() == null ^ this.getSpotFleetRequestIds() == null) {
            return false;
        }
        if (other.getSpotFleetRequestIds() != null && !other.getSpotFleetRequestIds().equals(this.getSpotFleetRequestIds())) {
            return false;
        }
        if (other.isTerminateInstances() == null ^ this.isTerminateInstances() == null) {
            return false;
        }
        return other.isTerminateInstances() == null || other.isTerminateInstances().equals(this.isTerminateInstances());
    }
}

