/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.FlowLogsResourceType;
import com.amazonaws.services.ec2.model.TrafficType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateFlowLogsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<String> resourceIds;
    private String resourceType;
    private String trafficType;
    private String logGroupName;
    private String deliverLogsPermissionArn;
    private String clientToken;

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new ListWithAutoConstructFlag();
            this.resourceIds.setAutoConstruct(true);
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
        resourceIdsCopy.addAll(resourceIds);
        this.resourceIds = resourceIdsCopy;
    }

    public CreateFlowLogsRequest withResourceIds(String ... resourceIds) {
        if (this.getResourceIds() == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String value : resourceIds) {
            this.getResourceIds().add(value);
        }
        return this;
    }

    public CreateFlowLogsRequest withResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
        } else {
            ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
            resourceIdsCopy.addAll(resourceIds);
            this.resourceIds = resourceIdsCopy;
        }
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public CreateFlowLogsRequest withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public void setResourceType(FlowLogsResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public CreateFlowLogsRequest withResourceType(FlowLogsResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public String getTrafficType() {
        return this.trafficType;
    }

    public void setTrafficType(String trafficType) {
        this.trafficType = trafficType;
    }

    public CreateFlowLogsRequest withTrafficType(String trafficType) {
        this.trafficType = trafficType;
        return this;
    }

    public void setTrafficType(TrafficType trafficType) {
        this.trafficType = trafficType.toString();
    }

    public CreateFlowLogsRequest withTrafficType(TrafficType trafficType) {
        this.trafficType = trafficType.toString();
        return this;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public CreateFlowLogsRequest withLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        return this;
    }

    public String getDeliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        this.deliverLogsPermissionArn = deliverLogsPermissionArn;
    }

    public CreateFlowLogsRequest withDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public CreateFlowLogsRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: " + this.getResourceIds() + ",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType() + ",");
        }
        if (this.getTrafficType() != null) {
            sb.append("TrafficType: " + this.getTrafficType() + ",");
        }
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: " + this.getLogGroupName() + ",");
        }
        if (this.getDeliverLogsPermissionArn() != null) {
            sb.append("DeliverLogsPermissionArn: " + this.getDeliverLogsPermissionArn() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficType() == null ? 0 : this.getTrafficType().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeliverLogsPermissionArn() == null ? 0 : this.getDeliverLogsPermissionArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)obj;
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTrafficType() == null ^ this.getTrafficType() == null) {
            return false;
        }
        if (other.getTrafficType() != null && !other.getTrafficType().equals(this.getTrafficType())) {
            return false;
        }
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getDeliverLogsPermissionArn() == null ^ this.getDeliverLogsPermissionArn() == null) {
            return false;
        }
        if (other.getDeliverLogsPermissionArn() != null && !other.getDeliverLogsPermissionArn().equals(this.getDeliverLogsPermissionArn())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }
}

