/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest;
import com.amazonaws.services.ec2.model.transform.DescribeScheduledInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeScheduledInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeScheduledInstancesRequest> {
    private ListWithAutoConstructFlag<String> scheduledInstanceIds;
    private SlotStartTimeRangeRequest slotStartTimeRange;
    private String nextToken;
    private Integer maxResults;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getScheduledInstanceIds() {
        if (this.scheduledInstanceIds == null) {
            this.scheduledInstanceIds = new ListWithAutoConstructFlag();
            this.scheduledInstanceIds.setAutoConstruct(true);
        }
        return this.scheduledInstanceIds;
    }

    public void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
        if (scheduledInstanceIds == null) {
            this.scheduledInstanceIds = null;
            return;
        }
        ListWithAutoConstructFlag scheduledInstanceIdsCopy = new ListWithAutoConstructFlag(scheduledInstanceIds.size());
        scheduledInstanceIdsCopy.addAll(scheduledInstanceIds);
        this.scheduledInstanceIds = scheduledInstanceIdsCopy;
    }

    public DescribeScheduledInstancesRequest withScheduledInstanceIds(String ... scheduledInstanceIds) {
        if (this.getScheduledInstanceIds() == null) {
            this.setScheduledInstanceIds(new ArrayList<String>(scheduledInstanceIds.length));
        }
        for (String value : scheduledInstanceIds) {
            this.getScheduledInstanceIds().add(value);
        }
        return this;
    }

    public DescribeScheduledInstancesRequest withScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
        if (scheduledInstanceIds == null) {
            this.scheduledInstanceIds = null;
        } else {
            ListWithAutoConstructFlag scheduledInstanceIdsCopy = new ListWithAutoConstructFlag(scheduledInstanceIds.size());
            scheduledInstanceIdsCopy.addAll(scheduledInstanceIds);
            this.scheduledInstanceIds = scheduledInstanceIdsCopy;
        }
        return this;
    }

    public SlotStartTimeRangeRequest getSlotStartTimeRange() {
        return this.slotStartTimeRange;
    }

    public void setSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
        this.slotStartTimeRange = slotStartTimeRange;
    }

    public DescribeScheduledInstancesRequest withSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
        this.slotStartTimeRange = slotStartTimeRange;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeScheduledInstancesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeScheduledInstancesRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeScheduledInstancesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeScheduledInstancesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeScheduledInstancesRequest> getDryRunRequest() {
        Request<DescribeScheduledInstancesRequest> request = new DescribeScheduledInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: " + this.getScheduledInstanceIds() + ",");
        }
        if (this.getSlotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: " + this.getSlotStartTimeRange() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScheduledInstanceIds() == null ? 0 : this.getScheduledInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getSlotStartTimeRange() == null ? 0 : this.getSlotStartTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest)obj;
        if (other.getScheduledInstanceIds() == null ^ this.getScheduledInstanceIds() == null) {
            return false;
        }
        if (other.getScheduledInstanceIds() != null && !other.getScheduledInstanceIds().equals(this.getScheduledInstanceIds())) {
            return false;
        }
        if (other.getSlotStartTimeRange() == null ^ this.getSlotStartTimeRange() == null) {
            return false;
        }
        if (other.getSlotStartTimeRange() != null && !other.getSlotStartTimeRange().equals(this.getSlotStartTimeRange())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

