/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.DescribeSecurityGroupReferencesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSecurityGroupReferencesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeSecurityGroupReferencesRequest> {
    private ListWithAutoConstructFlag<String> groupId;

    public List<String> getGroupId() {
        if (this.groupId == null) {
            this.groupId = new ListWithAutoConstructFlag();
            this.groupId.setAutoConstruct(true);
        }
        return this.groupId;
    }

    public void setGroupId(Collection<String> groupId) {
        if (groupId == null) {
            this.groupId = null;
            return;
        }
        ListWithAutoConstructFlag groupIdCopy = new ListWithAutoConstructFlag(groupId.size());
        groupIdCopy.addAll(groupId);
        this.groupId = groupIdCopy;
    }

    public DescribeSecurityGroupReferencesRequest withGroupId(String ... groupId) {
        if (this.getGroupId() == null) {
            this.setGroupId(new ArrayList<String>(groupId.length));
        }
        for (String value : groupId) {
            this.getGroupId().add(value);
        }
        return this;
    }

    public DescribeSecurityGroupReferencesRequest withGroupId(Collection<String> groupId) {
        if (groupId == null) {
            this.groupId = null;
        } else {
            ListWithAutoConstructFlag groupIdCopy = new ListWithAutoConstructFlag(groupId.size());
            groupIdCopy.addAll(groupId);
            this.groupId = groupIdCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeSecurityGroupReferencesRequest> getDryRunRequest() {
        Request<DescribeSecurityGroupReferencesRequest> request = new DescribeSecurityGroupReferencesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesRequest)) {
            return false;
        }
        DescribeSecurityGroupReferencesRequest other = (DescribeSecurityGroupReferencesRequest)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        return other.getGroupId() == null || other.getGroupId().equals(this.getGroupId());
    }
}

