/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeSnapshotsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSnapshotsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeSnapshotsRequest> {
    private ListWithAutoConstructFlag<String> snapshotIds;
    private ListWithAutoConstructFlag<String> ownerIds;
    private ListWithAutoConstructFlag<String> restorableByUserIds;
    private ListWithAutoConstructFlag<Filter> filters;
    private String nextToken;
    private Integer maxResults;

    public List<String> getSnapshotIds() {
        if (this.snapshotIds == null) {
            this.snapshotIds = new ListWithAutoConstructFlag();
            this.snapshotIds.setAutoConstruct(true);
        }
        return this.snapshotIds;
    }

    public void setSnapshotIds(Collection<String> snapshotIds) {
        if (snapshotIds == null) {
            this.snapshotIds = null;
            return;
        }
        ListWithAutoConstructFlag snapshotIdsCopy = new ListWithAutoConstructFlag(snapshotIds.size());
        snapshotIdsCopy.addAll(snapshotIds);
        this.snapshotIds = snapshotIdsCopy;
    }

    public DescribeSnapshotsRequest withSnapshotIds(String ... snapshotIds) {
        if (this.getSnapshotIds() == null) {
            this.setSnapshotIds(new ArrayList<String>(snapshotIds.length));
        }
        for (String value : snapshotIds) {
            this.getSnapshotIds().add(value);
        }
        return this;
    }

    public DescribeSnapshotsRequest withSnapshotIds(Collection<String> snapshotIds) {
        if (snapshotIds == null) {
            this.snapshotIds = null;
        } else {
            ListWithAutoConstructFlag snapshotIdsCopy = new ListWithAutoConstructFlag(snapshotIds.size());
            snapshotIdsCopy.addAll(snapshotIds);
            this.snapshotIds = snapshotIdsCopy;
        }
        return this;
    }

    public List<String> getOwnerIds() {
        if (this.ownerIds == null) {
            this.ownerIds = new ListWithAutoConstructFlag();
            this.ownerIds.setAutoConstruct(true);
        }
        return this.ownerIds;
    }

    public void setOwnerIds(Collection<String> ownerIds) {
        if (ownerIds == null) {
            this.ownerIds = null;
            return;
        }
        ListWithAutoConstructFlag ownerIdsCopy = new ListWithAutoConstructFlag(ownerIds.size());
        ownerIdsCopy.addAll(ownerIds);
        this.ownerIds = ownerIdsCopy;
    }

    public DescribeSnapshotsRequest withOwnerIds(String ... ownerIds) {
        if (this.getOwnerIds() == null) {
            this.setOwnerIds(new ArrayList<String>(ownerIds.length));
        }
        for (String value : ownerIds) {
            this.getOwnerIds().add(value);
        }
        return this;
    }

    public DescribeSnapshotsRequest withOwnerIds(Collection<String> ownerIds) {
        if (ownerIds == null) {
            this.ownerIds = null;
        } else {
            ListWithAutoConstructFlag ownerIdsCopy = new ListWithAutoConstructFlag(ownerIds.size());
            ownerIdsCopy.addAll(ownerIds);
            this.ownerIds = ownerIdsCopy;
        }
        return this;
    }

    public List<String> getRestorableByUserIds() {
        if (this.restorableByUserIds == null) {
            this.restorableByUserIds = new ListWithAutoConstructFlag();
            this.restorableByUserIds.setAutoConstruct(true);
        }
        return this.restorableByUserIds;
    }

    public void setRestorableByUserIds(Collection<String> restorableByUserIds) {
        if (restorableByUserIds == null) {
            this.restorableByUserIds = null;
            return;
        }
        ListWithAutoConstructFlag restorableByUserIdsCopy = new ListWithAutoConstructFlag(restorableByUserIds.size());
        restorableByUserIdsCopy.addAll(restorableByUserIds);
        this.restorableByUserIds = restorableByUserIdsCopy;
    }

    public DescribeSnapshotsRequest withRestorableByUserIds(String ... restorableByUserIds) {
        if (this.getRestorableByUserIds() == null) {
            this.setRestorableByUserIds(new ArrayList<String>(restorableByUserIds.length));
        }
        for (String value : restorableByUserIds) {
            this.getRestorableByUserIds().add(value);
        }
        return this;
    }

    public DescribeSnapshotsRequest withRestorableByUserIds(Collection<String> restorableByUserIds) {
        if (restorableByUserIds == null) {
            this.restorableByUserIds = null;
        } else {
            ListWithAutoConstructFlag restorableByUserIdsCopy = new ListWithAutoConstructFlag(restorableByUserIds.size());
            restorableByUserIdsCopy.addAll(restorableByUserIds);
            this.restorableByUserIds = restorableByUserIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeSnapshotsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeSnapshotsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeSnapshotsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeSnapshotsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public Request<DescribeSnapshotsRequest> getDryRunRequest() {
        Request<DescribeSnapshotsRequest> request = new DescribeSnapshotsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshotIds() != null) {
            sb.append("SnapshotIds: " + this.getSnapshotIds() + ",");
        }
        if (this.getOwnerIds() != null) {
            sb.append("OwnerIds: " + this.getOwnerIds() + ",");
        }
        if (this.getRestorableByUserIds() != null) {
            sb.append("RestorableByUserIds: " + this.getRestorableByUserIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshotIds() == null ? 0 : this.getSnapshotIds().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerIds() == null ? 0 : this.getOwnerIds().hashCode());
        hashCode = 31 * hashCode + (this.getRestorableByUserIds() == null ? 0 : this.getRestorableByUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest)obj;
        if (other.getSnapshotIds() == null ^ this.getSnapshotIds() == null) {
            return false;
        }
        if (other.getSnapshotIds() != null && !other.getSnapshotIds().equals(this.getSnapshotIds())) {
            return false;
        }
        if (other.getOwnerIds() == null ^ this.getOwnerIds() == null) {
            return false;
        }
        if (other.getOwnerIds() != null && !other.getOwnerIds().equals(this.getOwnerIds())) {
            return false;
        }
        if (other.getRestorableByUserIds() == null ^ this.getRestorableByUserIds() == null) {
            return false;
        }
        if (other.getRestorableByUserIds() != null && !other.getRestorableByUserIds().equals(this.getRestorableByUserIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }
}

