/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.SnapshotDiskContainer;
import com.amazonaws.services.ec2.model.transform.ImportSnapshotRequestMarshaller;
import java.io.Serializable;

public class ImportSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ImportSnapshotRequest> {
    private String description;
    private SnapshotDiskContainer diskContainer;
    private ClientData clientData;
    private String clientToken;
    private String roleName;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportSnapshotRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public SnapshotDiskContainer getDiskContainer() {
        return this.diskContainer;
    }

    public void setDiskContainer(SnapshotDiskContainer diskContainer) {
        this.diskContainer = diskContainer;
    }

    public ImportSnapshotRequest withDiskContainer(SnapshotDiskContainer diskContainer) {
        this.diskContainer = diskContainer;
        return this;
    }

    public ClientData getClientData() {
        return this.clientData;
    }

    public void setClientData(ClientData clientData) {
        this.clientData = clientData;
    }

    public ImportSnapshotRequest withClientData(ClientData clientData) {
        this.clientData = clientData;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public ImportSnapshotRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public ImportSnapshotRequest withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Override
    public Request<ImportSnapshotRequest> getDryRunRequest() {
        Request<ImportSnapshotRequest> request = new ImportSnapshotRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDiskContainer() != null) {
            sb.append("DiskContainer: " + this.getDiskContainer() + ",");
        }
        if (this.getClientData() != null) {
            sb.append("ClientData: " + this.getClientData() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: " + this.getRoleName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDiskContainer() == null ? 0 : this.getDiskContainer().hashCode());
        hashCode = 31 * hashCode + (this.getClientData() == null ? 0 : this.getClientData().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDiskContainer() == null ^ this.getDiskContainer() == null) {
            return false;
        }
        if (other.getDiskContainer() != null && !other.getDiskContainer().equals(this.getDiskContainer())) {
            return false;
        }
        if (other.getClientData() == null ^ this.getClientData() == null) {
            return false;
        }
        if (other.getClientData() != null && !other.getClientData().equals(this.getClientData())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        return other.getRoleName() == null || other.getRoleName().equals(this.getRoleName());
    }
}

