/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ModifyVpcEndpointRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyVpcEndpointRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ModifyVpcEndpointRequest> {
    private String vpcEndpointId;
    private Boolean resetPolicy;
    private String policyDocument;
    private ListWithAutoConstructFlag<String> addRouteTableIds;
    private ListWithAutoConstructFlag<String> removeRouteTableIds;

    public String getVpcEndpointId() {
        return this.vpcEndpointId;
    }

    public void setVpcEndpointId(String vpcEndpointId) {
        this.vpcEndpointId = vpcEndpointId;
    }

    public ModifyVpcEndpointRequest withVpcEndpointId(String vpcEndpointId) {
        this.vpcEndpointId = vpcEndpointId;
        return this;
    }

    public Boolean isResetPolicy() {
        return this.resetPolicy;
    }

    public void setResetPolicy(Boolean resetPolicy) {
        this.resetPolicy = resetPolicy;
    }

    public ModifyVpcEndpointRequest withResetPolicy(Boolean resetPolicy) {
        this.resetPolicy = resetPolicy;
        return this;
    }

    public Boolean getResetPolicy() {
        return this.resetPolicy;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public ModifyVpcEndpointRequest withPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
        return this;
    }

    public List<String> getAddRouteTableIds() {
        if (this.addRouteTableIds == null) {
            this.addRouteTableIds = new ListWithAutoConstructFlag();
            this.addRouteTableIds.setAutoConstruct(true);
        }
        return this.addRouteTableIds;
    }

    public void setAddRouteTableIds(Collection<String> addRouteTableIds) {
        if (addRouteTableIds == null) {
            this.addRouteTableIds = null;
            return;
        }
        ListWithAutoConstructFlag addRouteTableIdsCopy = new ListWithAutoConstructFlag(addRouteTableIds.size());
        addRouteTableIdsCopy.addAll(addRouteTableIds);
        this.addRouteTableIds = addRouteTableIdsCopy;
    }

    public ModifyVpcEndpointRequest withAddRouteTableIds(String ... addRouteTableIds) {
        if (this.getAddRouteTableIds() == null) {
            this.setAddRouteTableIds(new ArrayList<String>(addRouteTableIds.length));
        }
        for (String value : addRouteTableIds) {
            this.getAddRouteTableIds().add(value);
        }
        return this;
    }

    public ModifyVpcEndpointRequest withAddRouteTableIds(Collection<String> addRouteTableIds) {
        if (addRouteTableIds == null) {
            this.addRouteTableIds = null;
        } else {
            ListWithAutoConstructFlag addRouteTableIdsCopy = new ListWithAutoConstructFlag(addRouteTableIds.size());
            addRouteTableIdsCopy.addAll(addRouteTableIds);
            this.addRouteTableIds = addRouteTableIdsCopy;
        }
        return this;
    }

    public List<String> getRemoveRouteTableIds() {
        if (this.removeRouteTableIds == null) {
            this.removeRouteTableIds = new ListWithAutoConstructFlag();
            this.removeRouteTableIds.setAutoConstruct(true);
        }
        return this.removeRouteTableIds;
    }

    public void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
        if (removeRouteTableIds == null) {
            this.removeRouteTableIds = null;
            return;
        }
        ListWithAutoConstructFlag removeRouteTableIdsCopy = new ListWithAutoConstructFlag(removeRouteTableIds.size());
        removeRouteTableIdsCopy.addAll(removeRouteTableIds);
        this.removeRouteTableIds = removeRouteTableIdsCopy;
    }

    public ModifyVpcEndpointRequest withRemoveRouteTableIds(String ... removeRouteTableIds) {
        if (this.getRemoveRouteTableIds() == null) {
            this.setRemoveRouteTableIds(new ArrayList<String>(removeRouteTableIds.length));
        }
        for (String value : removeRouteTableIds) {
            this.getRemoveRouteTableIds().add(value);
        }
        return this;
    }

    public ModifyVpcEndpointRequest withRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
        if (removeRouteTableIds == null) {
            this.removeRouteTableIds = null;
        } else {
            ListWithAutoConstructFlag removeRouteTableIdsCopy = new ListWithAutoConstructFlag(removeRouteTableIds.size());
            removeRouteTableIdsCopy.addAll(removeRouteTableIds);
            this.removeRouteTableIds = removeRouteTableIdsCopy;
        }
        return this;
    }

    @Override
    public Request<ModifyVpcEndpointRequest> getDryRunRequest() {
        Request<ModifyVpcEndpointRequest> request = new ModifyVpcEndpointRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcEndpointId() != null) {
            sb.append("VpcEndpointId: " + this.getVpcEndpointId() + ",");
        }
        if (this.isResetPolicy() != null) {
            sb.append("ResetPolicy: " + this.isResetPolicy() + ",");
        }
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: " + this.getPolicyDocument() + ",");
        }
        if (this.getAddRouteTableIds() != null) {
            sb.append("AddRouteTableIds: " + this.getAddRouteTableIds() + ",");
        }
        if (this.getRemoveRouteTableIds() != null) {
            sb.append("RemoveRouteTableIds: " + this.getRemoveRouteTableIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcEndpointId() == null ? 0 : this.getVpcEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.isResetPolicy() == null ? 0 : this.isResetPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getAddRouteTableIds() == null ? 0 : this.getAddRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveRouteTableIds() == null ? 0 : this.getRemoveRouteTableIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)obj;
        if (other.getVpcEndpointId() == null ^ this.getVpcEndpointId() == null) {
            return false;
        }
        if (other.getVpcEndpointId() != null && !other.getVpcEndpointId().equals(this.getVpcEndpointId())) {
            return false;
        }
        if (other.isResetPolicy() == null ^ this.isResetPolicy() == null) {
            return false;
        }
        if (other.isResetPolicy() != null && !other.isResetPolicy().equals(this.isResetPolicy())) {
            return false;
        }
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getAddRouteTableIds() == null ^ this.getAddRouteTableIds() == null) {
            return false;
        }
        if (other.getAddRouteTableIds() != null && !other.getAddRouteTableIds().equals(this.getAddRouteTableIds())) {
            return false;
        }
        if (other.getRemoveRouteTableIds() == null ^ this.getRemoveRouteTableIds() == null) {
            return false;
        }
        return other.getRemoveRouteTableIds() == null || other.getRemoveRouteTableIds().equals(this.getRemoveRouteTableIds());
    }
}

