/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScheduledInstanceRecurrenceRequest
implements Serializable {
    private String frequency;
    private Integer interval;
    private ListWithAutoConstructFlag<Integer> occurrenceDays;
    private Boolean occurrenceRelativeToEnd;
    private String occurrenceUnit;

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public ScheduledInstanceRecurrenceRequest withFrequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public ScheduledInstanceRecurrenceRequest withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public List<Integer> getOccurrenceDays() {
        if (this.occurrenceDays == null) {
            this.occurrenceDays = new ListWithAutoConstructFlag();
            this.occurrenceDays.setAutoConstruct(true);
        }
        return this.occurrenceDays;
    }

    public void setOccurrenceDays(Collection<Integer> occurrenceDays) {
        if (occurrenceDays == null) {
            this.occurrenceDays = null;
            return;
        }
        ListWithAutoConstructFlag occurrenceDaysCopy = new ListWithAutoConstructFlag(occurrenceDays.size());
        occurrenceDaysCopy.addAll(occurrenceDays);
        this.occurrenceDays = occurrenceDaysCopy;
    }

    public ScheduledInstanceRecurrenceRequest withOccurrenceDays(Integer ... occurrenceDays) {
        if (this.getOccurrenceDays() == null) {
            this.setOccurrenceDays(new ArrayList<Integer>(occurrenceDays.length));
        }
        for (Integer value : occurrenceDays) {
            this.getOccurrenceDays().add(value);
        }
        return this;
    }

    public ScheduledInstanceRecurrenceRequest withOccurrenceDays(Collection<Integer> occurrenceDays) {
        if (occurrenceDays == null) {
            this.occurrenceDays = null;
        } else {
            ListWithAutoConstructFlag occurrenceDaysCopy = new ListWithAutoConstructFlag(occurrenceDays.size());
            occurrenceDaysCopy.addAll(occurrenceDays);
            this.occurrenceDays = occurrenceDaysCopy;
        }
        return this;
    }

    public Boolean isOccurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
        this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
    }

    public ScheduledInstanceRecurrenceRequest withOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
        this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        return this;
    }

    public Boolean getOccurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public String getOccurrenceUnit() {
        return this.occurrenceUnit;
    }

    public void setOccurrenceUnit(String occurrenceUnit) {
        this.occurrenceUnit = occurrenceUnit;
    }

    public ScheduledInstanceRecurrenceRequest withOccurrenceUnit(String occurrenceUnit) {
        this.occurrenceUnit = occurrenceUnit;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrequency() != null) {
            sb.append("Frequency: " + this.getFrequency() + ",");
        }
        if (this.getInterval() != null) {
            sb.append("Interval: " + this.getInterval() + ",");
        }
        if (this.getOccurrenceDays() != null) {
            sb.append("OccurrenceDays: " + this.getOccurrenceDays() + ",");
        }
        if (this.isOccurrenceRelativeToEnd() != null) {
            sb.append("OccurrenceRelativeToEnd: " + this.isOccurrenceRelativeToEnd() + ",");
        }
        if (this.getOccurrenceUnit() != null) {
            sb.append("OccurrenceUnit: " + this.getOccurrenceUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getInterval() == null ? 0 : this.getInterval().hashCode());
        hashCode = 31 * hashCode + (this.getOccurrenceDays() == null ? 0 : this.getOccurrenceDays().hashCode());
        hashCode = 31 * hashCode + (this.isOccurrenceRelativeToEnd() == null ? 0 : this.isOccurrenceRelativeToEnd().hashCode());
        hashCode = 31 * hashCode + (this.getOccurrenceUnit() == null ? 0 : this.getOccurrenceUnit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest)obj;
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getInterval() == null ^ this.getInterval() == null) {
            return false;
        }
        if (other.getInterval() != null && !other.getInterval().equals(this.getInterval())) {
            return false;
        }
        if (other.getOccurrenceDays() == null ^ this.getOccurrenceDays() == null) {
            return false;
        }
        if (other.getOccurrenceDays() != null && !other.getOccurrenceDays().equals(this.getOccurrenceDays())) {
            return false;
        }
        if (other.isOccurrenceRelativeToEnd() == null ^ this.isOccurrenceRelativeToEnd() == null) {
            return false;
        }
        if (other.isOccurrenceRelativeToEnd() != null && !other.isOccurrenceRelativeToEnd().equals(this.isOccurrenceRelativeToEnd())) {
            return false;
        }
        if (other.getOccurrenceUnit() == null ^ this.getOccurrenceUnit() == null) {
            return false;
        }
        return other.getOccurrenceUnit() == null || other.getOccurrenceUnit().equals(this.getOccurrenceUnit());
    }
}

