/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScheduledInstancesNetworkInterface
implements Serializable {
    private String networkInterfaceId;
    private Integer deviceIndex;
    private String subnetId;
    private String description;
    private String privateIpAddress;
    private ListWithAutoConstructFlag<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;
    private Integer secondaryPrivateIpAddressCount;
    private Boolean associatePublicIpAddress;
    private ListWithAutoConstructFlag<String> groups;
    private Boolean deleteOnTermination;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public ScheduledInstancesNetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public ScheduledInstancesNetworkInterface withDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public ScheduledInstancesNetworkInterface withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScheduledInstancesNetworkInterface withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public ScheduledInstancesNetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public List<ScheduledInstancesPrivateIpAddressConfig> getPrivateIpAddressConfigs() {
        if (this.privateIpAddressConfigs == null) {
            this.privateIpAddressConfigs = new ListWithAutoConstructFlag();
            this.privateIpAddressConfigs.setAutoConstruct(true);
        }
        return this.privateIpAddressConfigs;
    }

    public void setPrivateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
        if (privateIpAddressConfigs == null) {
            this.privateIpAddressConfigs = null;
            return;
        }
        ListWithAutoConstructFlag privateIpAddressConfigsCopy = new ListWithAutoConstructFlag(privateIpAddressConfigs.size());
        privateIpAddressConfigsCopy.addAll(privateIpAddressConfigs);
        this.privateIpAddressConfigs = privateIpAddressConfigsCopy;
    }

    public ScheduledInstancesNetworkInterface withPrivateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... privateIpAddressConfigs) {
        if (this.getPrivateIpAddressConfigs() == null) {
            this.setPrivateIpAddressConfigs(new ArrayList<ScheduledInstancesPrivateIpAddressConfig>(privateIpAddressConfigs.length));
        }
        for (ScheduledInstancesPrivateIpAddressConfig value : privateIpAddressConfigs) {
            this.getPrivateIpAddressConfigs().add(value);
        }
        return this;
    }

    public ScheduledInstancesNetworkInterface withPrivateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
        if (privateIpAddressConfigs == null) {
            this.privateIpAddressConfigs = null;
        } else {
            ListWithAutoConstructFlag privateIpAddressConfigsCopy = new ListWithAutoConstructFlag(privateIpAddressConfigs.size());
            privateIpAddressConfigsCopy.addAll(privateIpAddressConfigs);
            this.privateIpAddressConfigs = privateIpAddressConfigsCopy;
        }
        return this;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public ScheduledInstancesNetworkInterface withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        return this;
    }

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public ScheduledInstancesNetworkInterface withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
        return this;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public ScheduledInstancesNetworkInterface withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public ScheduledInstancesNetworkInterface withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public Boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public void setDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    public ScheduledInstancesNetworkInterface withDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
        return this;
    }

    public Boolean getDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ",");
        }
        if (this.getDeviceIndex() != null) {
            sb.append("DeviceIndex: " + this.getDeviceIndex() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress() + ",");
        }
        if (this.getPrivateIpAddressConfigs() != null) {
            sb.append("PrivateIpAddressConfigs: " + this.getPrivateIpAddressConfigs() + ",");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: " + this.getSecondaryPrivateIpAddressCount() + ",");
        }
        if (this.isAssociatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: " + this.isAssociatePublicIpAddress() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.isDeleteOnTermination() != null) {
            sb.append("DeleteOnTermination: " + this.isDeleteOnTermination());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceIndex() == null ? 0 : this.getDeviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddressConfigs() == null ? 0 : this.getPrivateIpAddressConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.isAssociatePublicIpAddress() == null ? 0 : this.isAssociatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.isDeleteOnTermination() == null ? 0 : this.isDeleteOnTermination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesNetworkInterface)) {
            return false;
        }
        ScheduledInstancesNetworkInterface other = (ScheduledInstancesNetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getDeviceIndex() == null ^ this.getDeviceIndex() == null) {
            return false;
        }
        if (other.getDeviceIndex() != null && !other.getDeviceIndex().equals(this.getDeviceIndex())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateIpAddressConfigs() == null ^ this.getPrivateIpAddressConfigs() == null) {
            return false;
        }
        if (other.getPrivateIpAddressConfigs() != null && !other.getPrivateIpAddressConfigs().equals(this.getPrivateIpAddressConfigs())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() != null && !other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.isAssociatePublicIpAddress() == null ^ this.isAssociatePublicIpAddress() == null) {
            return false;
        }
        if (other.isAssociatePublicIpAddress() != null && !other.isAssociatePublicIpAddress().equals(this.isAssociatePublicIpAddress())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.isDeleteOnTermination() == null ^ this.isDeleteOnTermination() == null) {
            return false;
        }
        return other.isDeleteOnTermination() == null || other.isDeleteOnTermination().equals(this.isDeleteOnTermination());
    }
}

