/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.StaleIpPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StaleSecurityGroup
implements Serializable {
    private String groupId;
    private String groupName;
    private String description;
    private String vpcId;
    private ListWithAutoConstructFlag<StaleIpPermission> staleIpPermissions;
    private ListWithAutoConstructFlag<StaleIpPermission> staleIpPermissionsEgress;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public StaleSecurityGroup withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public StaleSecurityGroup withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StaleSecurityGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public StaleSecurityGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<StaleIpPermission> getStaleIpPermissions() {
        if (this.staleIpPermissions == null) {
            this.staleIpPermissions = new ListWithAutoConstructFlag();
            this.staleIpPermissions.setAutoConstruct(true);
        }
        return this.staleIpPermissions;
    }

    public void setStaleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
        if (staleIpPermissions == null) {
            this.staleIpPermissions = null;
            return;
        }
        ListWithAutoConstructFlag staleIpPermissionsCopy = new ListWithAutoConstructFlag(staleIpPermissions.size());
        staleIpPermissionsCopy.addAll(staleIpPermissions);
        this.staleIpPermissions = staleIpPermissionsCopy;
    }

    public StaleSecurityGroup withStaleIpPermissions(StaleIpPermission ... staleIpPermissions) {
        if (this.getStaleIpPermissions() == null) {
            this.setStaleIpPermissions(new ArrayList<StaleIpPermission>(staleIpPermissions.length));
        }
        for (StaleIpPermission value : staleIpPermissions) {
            this.getStaleIpPermissions().add(value);
        }
        return this;
    }

    public StaleSecurityGroup withStaleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
        if (staleIpPermissions == null) {
            this.staleIpPermissions = null;
        } else {
            ListWithAutoConstructFlag staleIpPermissionsCopy = new ListWithAutoConstructFlag(staleIpPermissions.size());
            staleIpPermissionsCopy.addAll(staleIpPermissions);
            this.staleIpPermissions = staleIpPermissionsCopy;
        }
        return this;
    }

    public List<StaleIpPermission> getStaleIpPermissionsEgress() {
        if (this.staleIpPermissionsEgress == null) {
            this.staleIpPermissionsEgress = new ListWithAutoConstructFlag();
            this.staleIpPermissionsEgress.setAutoConstruct(true);
        }
        return this.staleIpPermissionsEgress;
    }

    public void setStaleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
        if (staleIpPermissionsEgress == null) {
            this.staleIpPermissionsEgress = null;
            return;
        }
        ListWithAutoConstructFlag staleIpPermissionsEgressCopy = new ListWithAutoConstructFlag(staleIpPermissionsEgress.size());
        staleIpPermissionsEgressCopy.addAll(staleIpPermissionsEgress);
        this.staleIpPermissionsEgress = staleIpPermissionsEgressCopy;
    }

    public StaleSecurityGroup withStaleIpPermissionsEgress(StaleIpPermission ... staleIpPermissionsEgress) {
        if (this.getStaleIpPermissionsEgress() == null) {
            this.setStaleIpPermissionsEgress(new ArrayList<StaleIpPermission>(staleIpPermissionsEgress.length));
        }
        for (StaleIpPermission value : staleIpPermissionsEgress) {
            this.getStaleIpPermissionsEgress().add(value);
        }
        return this;
    }

    public StaleSecurityGroup withStaleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
        if (staleIpPermissionsEgress == null) {
            this.staleIpPermissionsEgress = null;
        } else {
            ListWithAutoConstructFlag staleIpPermissionsEgressCopy = new ListWithAutoConstructFlag(staleIpPermissionsEgress.size());
            staleIpPermissionsEgressCopy.addAll(staleIpPermissionsEgress);
            this.staleIpPermissionsEgress = staleIpPermissionsEgressCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId() + ",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getStaleIpPermissions() != null) {
            sb.append("StaleIpPermissions: " + this.getStaleIpPermissions() + ",");
        }
        if (this.getStaleIpPermissionsEgress() != null) {
            sb.append("StaleIpPermissionsEgress: " + this.getStaleIpPermissionsEgress());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getStaleIpPermissions() == null ? 0 : this.getStaleIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getStaleIpPermissionsEgress() == null ? 0 : this.getStaleIpPermissionsEgress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getStaleIpPermissions() == null ^ this.getStaleIpPermissions() == null) {
            return false;
        }
        if (other.getStaleIpPermissions() != null && !other.getStaleIpPermissions().equals(this.getStaleIpPermissions())) {
            return false;
        }
        if (other.getStaleIpPermissionsEgress() == null ^ this.getStaleIpPermissionsEgress() == null) {
            return false;
        }
        return other.getStaleIpPermissionsEgress() == null || other.getStaleIpPermissionsEgress().equals(this.getStaleIpPermissionsEgress());
    }
}

