/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ActiveInstance;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ActiveInstanceStaxUnmarshaller
implements Unmarshaller<ActiveInstance, StaxUnmarshallerContext> {
    private static ActiveInstanceStaxUnmarshaller instance;

    public ActiveInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        ActiveInstance activeInstance = new ActiveInstance();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return activeInstance;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("instanceType", targetDepth)) {
                    activeInstance.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceId", targetDepth)) {
                    activeInstance.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("spotInstanceRequestId", targetDepth)) continue;
                activeInstance.setSpotInstanceRequestId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return activeInstance;
    }

    public static ActiveInstanceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ActiveInstanceStaxUnmarshaller();
        }
        return instance;
    }
}

